/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.gui.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class AutoFillEditBox
extends EditBox {
    private final Supplier<List<String>> fillOptions;
    private final int optionsToDisplay;
    private List<String> matchingFillOptions = List.of();
    private int viewOptionIndex = 0;
    private int highlightedOptionIndex = 0;

    public AutoFillEditBox(Font font, int width, int height, Component message, Supplier<List<String>> fillOptions, int optionsToDisplay) {
        super(font, width, height, message);
        this.fillOptions = fillOptions;
        this.optionsToDisplay = optionsToDisplay;
        this.rebuildMatchingFillOptions();
    }

    public AutoFillEditBox(Font font, int x, int y, int width, int height, Component message, Supplier<List<String>> fillOptions, int optionsToDisplay) {
        super(font, x, y, width, height, message);
        this.fillOptions = fillOptions;
        this.optionsToDisplay = optionsToDisplay;
        this.rebuildMatchingFillOptions();
    }

    public AutoFillEditBox(Font font, int x, int y, int width, int height, AutoFillEditBox editBox, Component message, Supplier<List<String>> fillOptions, int optionsToDisplay) {
        super(font, x, y, width, height, (EditBox)editBox, message);
        this.fillOptions = fillOptions;
        this.optionsToDisplay = optionsToDisplay;
        this.rebuildMatchingFillOptions();
    }

    public final List<String> getFillOptions() {
        return this.fillOptions.get();
    }

    public final int getOptionsToDisplay() {
        return this.optionsToDisplay;
    }

    public final List<String> getMatchingFillOptions() {
        return this.matchingFillOptions;
    }

    private List<String> filterMatchingFillOptions(String text) {
        ArrayList matchingFillOptions = Lists.newArrayList();
        for (String option : this.getFillOptions()) {
            if (!option.startsWith(text) || option.equals(text)) continue;
            matchingFillOptions.add(option);
        }
        Collections.sort(matchingFillOptions);
        return Collections.unmodifiableList(matchingFillOptions);
    }

    private void updateSuggestion() {
        if (this.highlightedOptionIndex > -1 && this.matchingFillOptions.size() > this.highlightedOptionIndex) {
            this.setSuggestion(this.matchingFillOptions.get(this.highlightedOptionIndex).substring(this.getValue().length()));
        } else {
            this.setSuggestion(null);
        }
    }

    private void rebuildMatchingFillOptions() {
        this.matchingFillOptions = this.filterMatchingFillOptions(this.getValue());
        this.viewOptionIndex = 0;
        this.highlightedOptionIndex = 0;
        this.updateSuggestion();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.highlightedOptionIndex = Math.max(0, this.highlightedOptionIndex - 1);
            if (this.highlightedOptionIndex < this.viewOptionIndex) {
                this.viewOptionIndex = this.highlightedOptionIndex;
            }
            this.updateSuggestion();
            return true;
        }
        if (keyCode == 264) {
            this.highlightedOptionIndex = Math.min(this.matchingFillOptions.size() - 1, this.highlightedOptionIndex + 1);
            if (this.highlightedOptionIndex > this.viewOptionIndex + this.optionsToDisplay - 1) {
                ++this.viewOptionIndex;
            }
            this.updateSuggestion();
            return true;
        }
        if (keyCode == 258) {
            if (this.matchingFillOptions.size() > this.highlightedOptionIndex) {
                this.setValue(this.matchingFillOptions.get(this.highlightedOptionIndex));
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void onValueChange(String newText) {
        this.rebuildMatchingFillOptions();
        super.onValueChange(newText);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        if (this.isVisible() && this.isFocused() && !this.matchingFillOptions.isEmpty()) {
            int endIndex = Math.min(this.matchingFillOptions.size(), this.viewOptionIndex + this.optionsToDisplay);
            int backgroundWidth = 0;
            for (int index = this.viewOptionIndex; index < endIndex; ++index) {
                String option = this.matchingFillOptions.get(index);
                int optionWidth = Minecraft.getInstance().font.width(option) + 8;
                if (optionWidth <= backgroundWidth) continue;
                backgroundWidth = optionWidth;
            }
            int n = this.getX();
            int n2 = this.getBottom();
            int n3 = this.getX() + backgroundWidth;
            int n4 = this.getBottom();
            int n5 = Math.min(this.matchingFillOptions.size(), this.optionsToDisplay);
            Objects.requireNonNull(Minecraft.getInstance().font);
            graphics.fill(n, n2, n3, n4 + n5 * (9 + 4) + 4, -1442840576);
            int lineX = this.isBordered() ? this.getX() + 4 : this.getX();
            int lineY = this.getBottom() + 4;
            for (int index = this.viewOptionIndex; index < endIndex; ++index) {
                String option = this.matchingFillOptions.get(index);
                graphics.drawString(Minecraft.getInstance().font, option, lineX, lineY, this.highlightedOptionIndex == index ? this.textColor : this.textColorUneditable);
                Objects.requireNonNull(Minecraft.getInstance().font);
                lineY += 9 + 4;
            }
        }
    }
}

