/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.recipe;

import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MIRecipeJson;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapedRecipeBuilder;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapelessRecipeBuilder;
import net.swedz.tesseract.neoforge.helper.RecipeHelper;
import net.swedz.tesseract.neoforge.material.Material;
import net.swedz.tesseract.neoforge.material.part.MaterialPart;
import net.swedz.tesseract.neoforge.recipe.RecipeOfferable;

public class MIMachineRecipeBuilder
extends MIRecipeJson<MIMachineRecipeBuilder>
implements RecipeOfferable {
    protected Optional<Material> defaultMaterial = Optional.empty();
    protected final Set<MaterialPart> involvedParts = Sets.newHashSet();

    public MIMachineRecipeBuilder(MachineRecipeType type, int eu, int duration) {
        super(type, eu, duration);
    }

    public MIMachineRecipeBuilder(MIRecipeJson<?> otherWithSameData) {
        super(otherWithSameData);
    }

    public static MIMachineRecipeBuilder fromShaped(ShapedRecipeBuilder shaped, MachineRecipeType machine, int eu, int duration, int division) {
        ItemStack result = shaped.result();
        if (result == null) {
            throw new NullPointerException("No result set for recipe");
        }
        if (result.getCount() % division != 0) {
            throw new IllegalArgumentException("Output must be divisible by division");
        }
        MIMachineRecipeBuilder machineRecipe = (MIMachineRecipeBuilder)new MIMachineRecipeBuilder(machine, eu, duration).addItemOutput(result.getItem(), result.getCount() / division);
        for (Map.Entry<Character, Ingredient> entry : shaped.key().entrySet()) {
            int count = 0;
            for (String row : shaped.pattern()) {
                for (char c : row.toCharArray()) {
                    if (c != entry.getKey().charValue()) continue;
                    ++count;
                }
            }
            if (count % division != 0) {
                throw new IllegalArgumentException("Input must be divisible by division");
            }
            machineRecipe.addItemInput(entry.getValue(), count / division, 1.0f);
        }
        return machineRecipe;
    }

    public static MIMachineRecipeBuilder fromShapedToAssembler(ShapedRecipeBuilder shaped) {
        return MIMachineRecipeBuilder.fromShaped(shaped, MIMachineRecipeTypes.ASSEMBLER, 8, 200, 1);
    }

    public static MIMachineRecipeBuilder fromShapeless(ShapelessRecipeBuilder shaped, MachineRecipeType machine, int eu, int duration, int division) {
        ItemStack result = shaped.result();
        if (result == null) {
            throw new NullPointerException("No result set for recipe");
        }
        if (result.getCount() % division != 0) {
            throw new IllegalArgumentException("Output must be divisible by division");
        }
        MIMachineRecipeBuilder machineRecipe = (MIMachineRecipeBuilder)new MIMachineRecipeBuilder(machine, eu, duration).addItemOutput(result.getItem(), result.getCount() / division);
        for (Ingredient ingredient : shaped.input()) {
            int count = 0;
            for (Ingredient other : shaped.input()) {
                if (!ingredient.equals((Object)other)) continue;
                ++count;
            }
            if (count % division != 0) {
                throw new IllegalArgumentException("Input must be divisible by division");
            }
            machineRecipe.addItemInput(ingredient, count / division, 1.0f);
        }
        return machineRecipe;
    }

    public static MIMachineRecipeBuilder fromShapelessToPacker(ShapelessRecipeBuilder shapeless) {
        return MIMachineRecipeBuilder.fromShapeless(shapeless, MIMachineRecipeTypes.PACKER, 2, 100, 1);
    }

    public static MIMachineRecipeBuilder fromShapelessToUnpackerAndFlip(ShapelessRecipeBuilder shapeless) {
        return MIMachineRecipeBuilder.fromShapeless(shapeless, MIMachineRecipeTypes.UNPACKER, 2, 100, 1).flip();
    }

    public MIMachineRecipeBuilder forMaterial(Material material) {
        this.defaultMaterial = Optional.ofNullable(material);
        return this;
    }

    public MIMachineRecipeBuilder flip() {
        MIMachineRecipeBuilder inversedRecipe = new MIMachineRecipeBuilder((MachineRecipeType)this.recipe.getType(), this.recipe.eu, this.recipe.duration).forMaterial(this.defaultMaterial.orElse(null));
        for (MachineRecipe.ItemInput itemInput : this.recipe.itemInputs) {
            inversedRecipe.addItemOutput((ItemLike)itemInput.ingredient().getItems()[0].getItem(), itemInput.amount(), itemInput.probability());
        }
        for (MachineRecipe.FluidInput fluidInput : this.recipe.fluidInputs) {
            inversedRecipe.addFluidOutput((Fluid)fluidInput.getInputFluids().getFirst(), (int)fluidInput.amount(), fluidInput.probability());
        }
        for (MachineRecipe.ItemOutput itemOutput : this.recipe.itemOutputs) {
            inversedRecipe.addItemInput((ItemLike)itemOutput.variant().getItem(), itemOutput.amount(), itemOutput.probability());
        }
        for (MachineRecipe.FluidOutput fluidOutput : this.recipe.fluidOutputs) {
            inversedRecipe.addFluidInput(fluidOutput.fluid(), (int)fluidOutput.amount(), fluidOutput.probability());
        }
        return inversedRecipe;
    }

    @Override
    public void validate() {
    }

    @Override
    public Recipe<?> convert() {
        return this.recipe;
    }

    public Set<MaterialPart> involvedParts() {
        return Sets.newHashSet(this.involvedParts);
    }

    public MIMachineRecipeBuilder addCondition(MachineProcessCondition condition) {
        this.recipe.conditions.add(condition);
        return this;
    }

    public MIMachineRecipeBuilder addItemInput(ResourceLocation itemId, int amount, float probability) {
        return (MIMachineRecipeBuilder)this.addItemInput(RecipeHelper.ingredient(itemId), amount, probability);
    }

    public MIMachineRecipeBuilder addItemInput(ResourceLocation itemId, int amount) {
        return this.addItemInput(itemId, amount, 1.0f);
    }

    public MIMachineRecipeBuilder addItemOutput(ResourceLocation itemId, int amount, float probability) {
        return (MIMachineRecipeBuilder)this.addItemOutput((ItemLike)BuiltInRegistries.ITEM.get(itemId), amount, probability);
    }

    public MIMachineRecipeBuilder addItemOutput(ResourceLocation itemId, int amount) {
        return this.addItemOutput(itemId, amount, 1.0f);
    }

    public MIMachineRecipeBuilder addPartInput(Material material, MaterialPart part, int count, float probability) {
        this.involvedParts.add(part);
        return material.has(part) ? (MIMachineRecipeBuilder)this.addItemInput(material.get(part).itemReference(), count, probability) : this;
    }

    public MIMachineRecipeBuilder addPartInput(Material material, MaterialPart part, int count) {
        this.involvedParts.add(part);
        return material.has(part) ? (MIMachineRecipeBuilder)this.addItemInput(material.get(part).itemReference(), count, 1.0f) : this;
    }

    public MIMachineRecipeBuilder addPartInput(MaterialPart part, int count, float probability) {
        return this.addPartInput(this.defaultMaterial.orElseThrow(), part, count, probability);
    }

    public MIMachineRecipeBuilder addPartInput(MaterialPart part, int count) {
        return this.addPartInput(this.defaultMaterial.orElseThrow(), part, count);
    }

    public MIMachineRecipeBuilder addPartOutput(Material material, MaterialPart part, int count, float probability) {
        this.involvedParts.add(part);
        return material.has(part) ? (MIMachineRecipeBuilder)this.addItemOutput((ItemLike)material.get(part).asItem(), count, probability) : this;
    }

    public MIMachineRecipeBuilder addPartOutput(Material material, MaterialPart part, int count) {
        this.involvedParts.add(part);
        return material.has(part) ? (MIMachineRecipeBuilder)this.addItemOutput((ItemLike)material.get(part).asItem(), count, 1.0f) : this;
    }

    public MIMachineRecipeBuilder addPartOutput(MaterialPart part, int count, float probability) {
        return this.addPartOutput(this.defaultMaterial.orElseThrow(), part, count, probability);
    }

    public MIMachineRecipeBuilder addPartOutput(MaterialPart part, int count) {
        return this.addPartOutput(this.defaultMaterial.orElseThrow(), part, count);
    }
}

