/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.helper.transfer;

import com.mojang.logging.LogUtils;
import dev.technici4n.grandpower.api.EnergyStorageUtil;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.swedz.tesseract.neoforge.helper.transfer.TransferCache;
import org.slf4j.Logger;

public class LongEnergyTransferCache
extends TransferCache<ILongEnergyStorage> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public LongEnergyTransferCache(BlockCapability<ILongEnergyStorage, Direction> capability, Supplier<ILongEnergyStorage> sourceHandler) {
        super(capability, sourceHandler);
    }

    public LongEnergyTransferCache(Supplier<ILongEnergyStorage> sourceHandler) {
        this((BlockCapability<ILongEnergyStorage, Direction>)ILongEnergyStorage.BLOCK, sourceHandler);
    }

    public boolean autoExtract(Level level, BlockPos pos, Direction direction, long maxAmount) {
        ILongEnergyStorage target = (ILongEnergyStorage)this.cache.output(level, pos, direction);
        if (target != null) {
            return EnergyStorageUtil.move((ILongEnergyStorage)((ILongEnergyStorage)this.sourceHandler()), (ILongEnergyStorage)target, (long)maxAmount) > 0L;
        }
        return false;
    }

    @Override
    public boolean autoExtract(Level level, BlockPos pos, Direction direction) {
        return this.autoExtract(level, pos, direction, Long.MAX_VALUE);
    }

    public boolean autoInsert(Level level, BlockPos pos, Direction direction, long maxAmount) {
        ILongEnergyStorage target = (ILongEnergyStorage)this.cache.input(level, pos, direction);
        if (target != null) {
            return EnergyStorageUtil.move((ILongEnergyStorage)target, (ILongEnergyStorage)((ILongEnergyStorage)this.sourceHandler()), (long)maxAmount) > 0L;
        }
        return false;
    }

    @Override
    public boolean autoInsert(Level level, BlockPos pos, Direction direction) {
        return this.autoInsert(level, pos, direction, Long.MAX_VALUE);
    }
}

