/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel;

import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.tesseract.neoforge.Tesseract;

public class ConfigurationPanel
implements GuiComponentServer<Params, Data> {
    public static final GuiComponentServer.Type<Params, Data> TYPE = new GuiComponentServer.Type(Tesseract.id("configuration_panel"), Params.STREAM_CODEC, Data.STREAM_CODEC);
    public final Behavior behavior;
    private final Component title;
    private final Component description;
    private final List<LineInfo> lines;

    public ConfigurationPanel(Behavior behavior, Component title, Component description, LineInfo ... lines) {
        Preconditions.checkArgument((lines.length > 0 ? 1 : 0) != 0);
        this.behavior = behavior;
        this.title = title;
        this.description = description;
        this.lines = List.of(lines);
    }

    public Params getParams() {
        return new Params(this.title, this.description, this.lines);
    }

    public Data extractData() {
        return new Data(IntStream.range(0, this.lines.size()).map(this.behavior::getCurrentIndex).boxed().toList());
    }

    public GuiComponentServer.Type<Params, Data> getType() {
        return TYPE;
    }

    public static interface Behavior {
        public void handleClick(int var1, int var2);

        public int getCurrentIndex(int var1);
    }

    public record Params(Component title, Component description, List<LineInfo> lines) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Params> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, Params::title, (StreamCodec)ComponentSerialization.STREAM_CODEC, Params::description, (StreamCodec)LineInfo.STREAM_CODEC.apply(ByteBufCodecs.list()), Params::lines, Params::new);
    }

    public record Data(List<Integer> selectedIndexes) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), Data::selectedIndexes, Data::new);
    }

    public record LineInfo(List<Component> translations, boolean useArrows) {
        public static final StreamCodec<RegistryFriendlyByteBuf, LineInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list()), LineInfo::translations, (StreamCodec)ByteBufCodecs.BOOL, LineInfo::useArrows, LineInfo::new);

        public int numValues() {
            return this.translations.size();
        }
    }
}

