/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render.entity;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.client.render.tile.RenderTileEnderTank;
import codechicken.lib.fluid.FluidUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.neoforged.neoforge.fluids.FluidStack;

public class TankLayerRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final String[] UUID_STRINGS = new String[]{"c85f3fd3-1754-45ec-ab3d-a33d6312dfef", "c501d550-7e3c-463e-8a95-256f86d9a47d", "cf3e2c7e-d703-48e0-808e-f139bf26ff9d", "44ba40ef-fd8a-446f-834b-5aea42119c92"};
    private static final Set<UUID> UUIDS = Arrays.stream(UUID_STRINGS).map(UUID::fromString).collect(Collectors.toSet());
    private static final Frequency BLANK = new Frequency();

    public TankLayerRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> parent) {
        super(parent);
    }

    public void render(PoseStack mStack, MultiBufferSource buffers, int packedLight, AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (UUIDS.contains(entity.getUUID())) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.brightness = packedLight;
            ccrs.overlay = OverlayTexture.NO_OVERLAY;
            Matrix4 mat = new Matrix4(mStack);
            mat.rotate(3.1415926535897403, Vector3.X_POS);
            mat.scale(0.5);
            if (entity.isCrouching()) {
                mat.translate(0.0, -0.5, 0.0);
            }
            if (entity.isFallFlying()) {
                headPitch = -45.0f;
            }
            mat.rotate((double)netHeadYaw * 0.017453292519943, Vector3.Y_NEG);
            mat.rotate((double)headPitch * 0.017453292519943, Vector3.X_POS);
            mat.translate(-0.5, 1.0, -0.5);
            RenderTileEnderTank.renderTank(ccrs, mat, buffers, 0, 1.5707964f, BLANK, 0);
            FluidStack stack = FluidUtils.water.copy();
            float bob = 0.45f + RenderUtils.getPearlBob((double)ClientUtils.getRenderTime()) * 2.0f;
            stack.setAmount((int)MathHelper.map((double)bob, (double)0.2, (double)0.6, (double)1000.0, (double)14000.0));
            mat.translate(-0.5, 0.0, -0.5);
            RenderTileEnderTank.renderFluid(ccrs, mat, buffers, stack);
        }
    }
}

