/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client;

import codechicken.lib.render.shader.CCShaderInstance;
import codechicken.lib.render.shader.CCUniform;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import org.jetbrains.annotations.Nullable;

public class Shaders {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    @Nullable
    private static CCShaderInstance starfieldShader;
    @Nullable
    private static CCUniform starfieldTime;
    @Nullable
    private static CCUniform starfieldYaw;
    @Nullable
    private static CCUniform starfieldPitch;
    @Nullable
    private static CCUniform starfieldAlpha;

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(Shaders::onRegisterShaders);
    }

    private static void onRegisterShaders(RegisterShadersEvent event) {
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enderstorage", (String)"starfield"), (VertexFormat)DefaultVertexFormat.POSITION), e -> {
            starfieldShader = (CCShaderInstance)e;
            starfieldTime = starfieldShader.getUniform("Time");
            starfieldYaw = starfieldShader.getUniform("Yaw");
            starfieldPitch = starfieldShader.getUniform("Pitch");
            starfieldAlpha = starfieldShader.getUniform("Alpha");
        });
    }

    public static CCShaderInstance starfieldShader() {
        return Objects.requireNonNull(starfieldShader);
    }

    public static CCUniform starfieldTime() {
        return Objects.requireNonNull(starfieldTime);
    }

    public static CCUniform starfieldYaw() {
        return Objects.requireNonNull(starfieldYaw);
    }

    public static CCUniform starfieldPitch() {
        return Objects.requireNonNull(starfieldPitch);
    }

    public static CCUniform starfieldAlpha() {
        return Objects.requireNonNull(starfieldAlpha);
    }
}

