/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.integrations.jei;

import cy.jdkdigital.productivetrees.common.block.ProductiveLogBlock;
import cy.jdkdigital.productivetrees.integrations.jei.ProductiveTreesJeiPlugin;
import cy.jdkdigital.productivetrees.recipe.LogStrippingRecipe;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class LogStrippingRecipeCategory
implements IRecipeCategory<LogStrippingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public LogStrippingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"textures/gui/jei/stripping.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 130, 60);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)TreeRegistrator.STRIPPER.get()));
    }

    public RecipeType<LogStrippingRecipe> getRecipeType() {
        return ProductiveTreesJeiPlugin.LOG_STRIPPING_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)"jei.productivetrees.log_stripping");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LogStrippingRecipe recipe, IFocusGroup focuses) {
        ProductiveLogBlock logBlock;
        TreeObject tree;
        BlockItem blockItem;
        Item item;
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 30, 15).addIngredients(recipe.input())).setSlotName("log");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 30, 34).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(Ingredient.of(ModTags.STRIPPER_TOOLS).getItems()))).setSlotName("axe");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 83, 15).addItemStack(recipe.output())).setSlotName("stripped");
        if (!recipe.input().isEmpty() && (item = recipe.input().getItems()[0].getItem()) instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof ProductiveLogBlock && (tree = TreeUtil.getTree((Block)(logBlock = (ProductiveLogBlock)item))) != null && tree.getStripDrop().isPresent()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 83, 34).addItemStack(tree.getStripDropStack())).setSlotName("bark");
        }
    }
}

