/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block;

import cy.jdkdigital.productivetrees.common.block.ProductiveLeavesBlock;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.CommonHooks;

public class ProductiveFruitBlock
extends ProductiveLeavesBlock {
    public ProductiveFruitBlock(BlockBehaviour.Properties properties, TreeObject treeObject) {
        super(properties, treeObject);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ProductiveFruitBlock.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        super.createBlockStateDefinition(blockStateBuilder);
        blockStateBuilder.add(new Property[]{ProductiveFruitBlock.getAgeProperty()});
    }

    public boolean triggerEvent(BlockState blockState, Level level, BlockPos blockPos, int p_49229_, int p_49230_) {
        super.triggerEvent(blockState, level, blockPos, p_49229_, p_49230_);
        BlockEntity blockentity = level.getBlockEntity(blockPos);
        return blockentity != null && blockentity.triggerEvent(p_49229_, p_49230_);
    }

    public static IntegerProperty getAgeProperty() {
        return BlockStateProperties.AGE_7;
    }

    public static int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState blockState) {
        return (Integer)blockState.getValue((Property)ProductiveFruitBlock.getAgeProperty());
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.treeObject.getFruit().getItem().getItem());
    }

    public BlockState getStateForAge(BlockState currentState, int age) {
        return (BlockState)currentState.setValue((Property)ProductiveFruitBlock.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public static boolean isMaxAge(BlockState blockState) {
        return (Integer)blockState.getValue((Property)ProductiveFruitBlock.getAgeProperty()) >= ProductiveFruitBlock.getMaxAge();
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return !ProductiveFruitBlock.isMaxAge(blockState);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource random) {
        int i;
        super.randomTick(state, level, blockPos, random);
        int light = level.getRawBrightness(blockPos, 0);
        if (light >= this.treeObject.getGrowthConditions().minLight() && light <= this.treeObject.getGrowthConditions().maxLight() && (i = this.getAge(state)) < ProductiveFruitBlock.getMaxAge() && CommonHooks.canCropGrow((Level)level, (BlockPos)blockPos, (BlockState)state, (random.nextInt((int)(25.0f / this.treeObject.getFruit().growthSpeed()) + 1) == 0 ? 1 : 0) != 0)) {
            level.setBlock(blockPos, this.getStateForAge(state, i + 1), 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pStack.is(Items.BONE_MEAL) && !ProductiveFruitBlock.isMaxAge(pState)) {
            if (!pLevel.isClientSide) {
                int i = this.getAge(pState);
                pLevel.setBlock(pPos, this.getStateForAge(pState, i + 1), 2);
                if (!pPlayer.isCreative()) {
                    pStack.shrink(1);
                }
            }
            pPlayer.swing(pHand);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (ProductiveFruitBlock.isMaxAge(pState)) {
            if (!pLevel.isClientSide) {
                ProductiveFruitBlock.popResource((Level)pLevel, (BlockPos)pPos.relative(pHitResult.getDirection()), (ItemStack)this.treeObject.getFruit().getItem());
                pLevel.setBlock(pPos, this.getStateForAge(pState, 0), 2);
            }
            pPlayer.swing(InteractionHand.MAIN_HAND);
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }
}

