/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.spell.filter;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractFilter;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.registry.ACNames;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class FilterRandom
extends AbstractFilter {
    public static final FilterRandom INSTANCE = new FilterRandom();
    static final double BASE_CHANCE = 0.5;
    public double chance = 0.5;

    private FilterRandom() {
        super(ArsControle.prefix(ACNames.GLYPH_FILTER_RANDOM), "Filter: Random");
    }

    public String getBookDescription() {
        return "Has a base 50% chance of resolving. If amplified overall, chance will be (100% - 50% / (2 ^ Amplification)). If dampened overall, chance will be (50% / (2 ^ Dampening)).";
    }

    public Integer getTypeIndex() {
        return 15;
    }

    public boolean shouldResolveOnBlock(BlockHitResult target, Level level) {
        return this.shouldResolve();
    }

    public boolean shouldResolveOnEntity(EntityHitResult target, Level level) {
        return this.shouldResolve();
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.chance = FilterRandom.calculateChance(spellStats.getAmpMultiplier());
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.chance = FilterRandom.calculateChance(spellStats.getAmpMultiplier());
        super.onResolveBlock(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public static double calculateChance(double amps) {
        return switch (Double.compare(amps, 0.0)) {
            case 1 -> 1.0 - 0.5 / Math.pow(2.0, amps);
            case -1 -> 0.5 / Math.pow(2.0, -amps);
            default -> 0.5;
        };
    }

    public boolean shouldResolve() {
        return ThreadLocalRandom.current().nextDouble() <= this.chance;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE});
    }

    protected void addAugmentCostOverrides(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 0);
        defaults.put(AugmentDampen.INSTANCE.getRegistryName(), 0);
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAmplify.INSTANCE, "Increases the chance of resolving");
        map.put((AbstractAugment)AugmentDampen.INSTANCE, "Decreases the chance of resolving");
    }
}

