/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.block.tile;

import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.block.tile.PortalTile;
import com.hollingsworth.arsnouveau.common.block.tile.SingleItemTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import dev.qther.ars_controle.block.ScrollHolderBlock;
import dev.qther.ars_controle.config.ACServerConfig;
import dev.qther.ars_controle.registry.ACRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ScrollHolderTile
extends SingleItemTile {
    private static final Direction[][] ORDERINGS = new Direction[][]{{Direction.NORTH, Direction.UP, Direction.SOUTH, Direction.DOWN, Direction.NORTH}, {Direction.WEST, Direction.UP, Direction.EAST, Direction.DOWN, Direction.WEST}, {Direction.NORTH, Direction.DOWN, Direction.SOUTH, Direction.UP, Direction.NORTH}, {Direction.WEST, Direction.DOWN, Direction.EAST, Direction.UP, Direction.WEST}};

    public ScrollHolderTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACRegistry.Tiles.SCROLL_HOLDER.get(), pos, state);
    }

    public boolean canHoldStack(ItemStack stack) {
        WarpScrollData data = (WarpScrollData)stack.get((Supplier)DataComponentRegistry.WARP_SCROLL);
        return data != null && data.isValid();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot == 0 && this.stack.isEmpty() && this.canHoldStack(stack);
    }

    public void update() {
        if (!(this.level instanceof ServerLevel)) {
            return;
        }
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue((Property)ScrollHolderBlock.FACING);
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)ScrollHolderBlock.HAS_SCROLL, (Comparable)Boolean.valueOf(!this.stack.isEmpty())), 3);
        if (!((Boolean)ServerConfig.ENABLE_WARP_PORTALS.get()).booleanValue()) {
            return;
        }
        block0: for (Direction[] order : ORDERINGS) {
            BlockPos.MutableBlockPos cursor = this.getBlockPos().mutable();
            BlockPos[] vertices = new BlockPos[6];
            vertices[0] = this.getBlockPos();
            Direction lastDir = null;
            for (int i = 0; i < order.length; ++i) {
                Direction direction = order[i];
                direction = this.getRotatedDirection(facing, direction);
                Direction inside = order[i == order.length - 1 ? 1 : i + 1];
                inside = this.getRotatedDirection(facing, inside);
                int distance = 0;
                do {
                    BlockState nextState = this.level.getBlockState((BlockPos)cursor.setWithOffset((Vec3i)cursor, direction));
                    BlockState insideState = this.level.getBlockState((BlockPos)cursor.setWithOffset((Vec3i)cursor, inside));
                    cursor.setWithOffset((Vec3i)cursor, inside.getOpposite());
                    if (insideState.getBlock() == ACRegistry.Blocks.SCROLL_HOLDER.get() || insideState.is(BlockTagProvider.DECORATIVE_AN)) break;
                    if (nextState.getBlock() == ACRegistry.Blocks.SCROLL_HOLDER.get()) {
                        cursor.setWithOffset((Vec3i)cursor, direction.getOpposite());
                        break;
                    }
                    if (!nextState.is(BlockTagProvider.DECORATIVE_AN)) {
                        BlockState nextInsideState = this.level.getBlockState((BlockPos)cursor.setWithOffset((Vec3i)cursor, inside));
                        cursor.setWithOffset((Vec3i)cursor, inside.getOpposite());
                        if (nextInsideState.getBlock() != ACRegistry.Blocks.SCROLL_HOLDER.get() && !nextInsideState.is(BlockTagProvider.DECORATIVE_AN)) {
                            cursor.setWithOffset((Vec3i)cursor, direction.getOpposite());
                        }
                        break;
                    }
                    if (++distance > 22) continue block0;
                } while (facing.getOpposite() != direction || cursor.get(direction.getAxis()) != this.getBlockPos().get(direction.getAxis()));
                if (i == 1 && cursor.distManhattan((Vec3i)this.getBlockPos()) > cursor.distManhattan((Vec3i)this.getBlockPos().offset(facing.getOpposite().getNormal()))) continue;
                vertices[i + 1] = cursor.immutable();
                lastDir = direction;
            }
            if (lastDir == null) continue;
            for (BlockPos vertex : vertices) {
                if (vertex == null) continue block0;
            }
            if (!cursor.setWithOffset((Vec3i)cursor, lastDir).equals((Object)this.getBlockPos())) continue;
            for (int i = 1; i < 3; ++i) {
                int distance = vertices[i].distManhattan((Vec3i)vertices[i + 1]);
                if (distance < 2 || distance > 22) continue block0;
            }
            int distance = vertices[1].distManhattan((Vec3i)vertices[4]);
            if (distance < 2 || distance > 22) continue;
            BlockPos start = vertices[1];
            BlockPos end = vertices[3];
            start = new BlockPos(start.getX() + Double.compare(end.getX(), start.getX()), start.getY() + Double.compare(end.getY(), start.getY()), start.getZ() + Double.compare(end.getZ(), start.getZ()));
            end = new BlockPos(end.getX() + Double.compare(start.getX(), end.getX()), end.getY() + Double.compare(start.getY(), end.getY()), end.getZ() + Double.compare(start.getZ(), end.getZ()));
            boolean needsSource = false;
            if (!this.stack.isEmpty()) {
                needsSource = true;
                for (BlockPos pos : BlockPos.betweenClosed((BlockPos)start, (BlockPos)end)) {
                    BlockState insideState = this.level.getBlockState(pos);
                    boolean isPortal = insideState.getBlock() instanceof PortalBlock;
                    if (isPortal) {
                        needsSource = false;
                    }
                    if (insideState.isAir() || isPortal) continue;
                    continue block0;
                }
            }
            Direction.Axis axis = Direction.Axis.Y;
            boolean horizontal = true;
            int firstY = vertices[1].getY();
            for (int i = 2; i < 4; ++i) {
                if (vertices[i].getY() == firstY) continue;
                horizontal = false;
            }
            if (!horizontal) {
                boolean facingHorizontal = facing.getAxis().isHorizontal();
                axis = vertices[facingHorizontal ? 1 : 2].getX() != vertices[facingHorizontal ? 2 : 3].getX() ? Direction.Axis.X : Direction.Axis.Z;
            }
            WarpScrollData data = (WarpScrollData)this.stack.get((Supplier)DataComponentRegistry.WARP_SCROLL);
            String displayName = this.stack.get(DataComponents.CUSTOM_NAME) != null ? this.stack.getHoverName().getString() : null;
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)start, (BlockPos)end)) {
                if (!this.stack.isEmpty() && this.level.getBlockState(pos).isAir()) {
                    if (needsSource) {
                        List taken;
                        needsSource = false;
                        int source = (Integer)ACServerConfig.SERVER.SCROLL_HOLDER_SOURCE_COST.get();
                        if (source > 0 && ((taken = SourceUtil.takeSourceMultipleWithParticles((BlockPos)this.getBlockPos(), (Level)this.level, (int)10, (int)source)) == null || taken.isEmpty())) continue block0;
                    }
                    this.level.setBlock(pos, (BlockState)BlockRegistry.PORTAL_BLOCK.defaultBlockState().setValue((Property)PortalBlock.AXIS, (Comparable)axis), 18);
                    BlockEntity blockEntity = this.level.getBlockEntity(pos);
                    if (!(blockEntity instanceof PortalTile)) continue;
                    PortalTile tile = (PortalTile)blockEntity;
                    tile.setFromScroll(data);
                    tile.displayName = displayName;
                    tile.isHorizontal = horizontal;
                    tile.updateBlock();
                    continue;
                }
                if (!this.stack.isEmpty() || !(this.level.getBlockState(pos).getBlock() instanceof PortalBlock)) continue;
                this.level.removeBlock(pos, false);
            }
        }
    }

    private Direction getRotatedDirection(Direction facing, Direction direction) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> direction.getOpposite();
            case Direction.UP -> direction;
            case Direction.SOUTH -> direction.getClockWise(Direction.Axis.X);
            case Direction.NORTH -> direction.getCounterClockWise(Direction.Axis.X);
            case Direction.WEST -> direction.getClockWise(Direction.Axis.Z);
            case Direction.EAST -> direction.getCounterClockWise(Direction.Axis.Z);
        };
    }

    public void setChanged() {
        super.setChanged();
        this.update();
    }

    public IItemHandler getItemHandler() {
        return new IItemHandler(){
            final ScrollHolderTile tile;
            {
                this.tile = ScrollHolderTile.this;
            }

            public int getSlots() {
                return this.tile.getContainerSize();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return this.tile.getItem(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                if (simulate) {
                    return stack.copyWithCount(stack.getCount() - 1);
                }
                this.tile.stack = stack.split(1);
                this.tile.setChanged();
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot != 0 || amount <= 0 || this.tile.stack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                if (simulate) {
                    return this.tile.stack.copyWithCount(1);
                }
                ItemStack extracted = this.tile.stack.split(amount);
                this.tile.setChanged();
                return extracted;
            }

            public int getSlotLimit(int slot) {
                return slot == 0 ? 1 : 0;
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return this.tile.canPlaceItem(slot, stack);
            }
        };
    }
}

