/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.block;

import com.hollingsworth.arsnouveau.api.util.ANEventBus;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.block.ContextualAnalogSignalling;
import dev.qther.ars_controle.block.tile.ScryersLinkageTile;
import dev.qther.ars_controle.packets.clientbound.PacketRenderBlockOutline;
import it.unimi.dsi.fastutil.Pair;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScryersLinkageBlock
extends TickableModBlock
implements EntityBlock,
ContextualAnalogSignalling {
    static final VoxelShape SHAPE;

    public ScryersLinkageBlock() {
        super(ScryersLinkageBlock.defaultProperties().noOcclusion().isValidSpawn(Blocks::never).isRedstoneConductor(ScryersLinkageBlock::never).isSuffocating(ScryersLinkageBlock::never).isViewBlocking(ScryersLinkageBlock::never));
    }

    public static Boolean never(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (ANEventBus.post((Event)new BlockEvent.BreakEvent(level, pos, state, player))) {
            return ItemInteractionResult.FAIL;
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (te == null) {
            ArsControle.LOGGER.warn("No tile entity in scryer's linkage.");
            return ItemInteractionResult.FAIL;
        }
        if (!(te instanceof ScryersLinkageTile)) {
            ArsControle.LOGGER.warn("Wrong tile entity in scryer's linkage.");
            return ItemInteractionResult.FAIL;
        }
        ScryersLinkageTile tile = (ScryersLinkageTile)te;
        if (!stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        GlobalPos b = tile.getTarget();
        if (b == null) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.get.none"));
            return ItemInteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PortUtil.sendMessage((Entity)serverPlayer, (Component)Component.translatable((String)"ars_controle.target.get.block", (Object[])new Object[]{b.pos().toShortString(), b.dimension().location().toString()}));
            if (serverPlayer.level().dimension().equals(b.dimension())) {
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PacketRenderBlockOutline(b.pos(), 200L), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new ScryersLinkageTile(pPos, pState);
    }

    @NotNull
    protected VoxelShape getVisualShape(@NotNull BlockState p_309057_, @NotNull BlockGetter p_308936_, @NotNull BlockPos p_308956_, @NotNull CollisionContext p_309006_) {
        return Shapes.empty();
    }

    protected float getShadeBrightness(@NotNull BlockState p_308911_, @NotNull BlockGetter p_308952_, @NotNull BlockPos p_308918_) {
        return 1.0f;
    }

    protected boolean propagatesSkylightDown(@NotNull BlockState p_309084_, @NotNull BlockGetter p_309133_, @NotNull BlockPos p_309097_) {
        return true;
    }

    protected int getSignal(@NotNull BlockState blockState, BlockGetter getter, @NotNull BlockPos pos, @NotNull Direction side) {
        BlockEntity be = getter.getBlockEntity(pos);
        if (!(be instanceof ScryersLinkageTile)) {
            return 0;
        }
        ScryersLinkageTile tile = (ScryersLinkageTile)be;
        Pair<Level, BlockPos> info = tile.getTargetInfo();
        if (info == null) {
            return 0;
        }
        Level targetLevel = (Level)info.first();
        BlockPos targetPos = (BlockPos)info.second();
        return targetLevel.getBlockState(targetPos).getSignal((BlockGetter)targetLevel, targetPos, side);
    }

    protected int getDirectSignal(@NotNull BlockState blockState, BlockGetter getter, @NotNull BlockPos pos, @NotNull Direction side) {
        BlockEntity be = getter.getBlockEntity(pos);
        if (!(be instanceof ScryersLinkageTile)) {
            return 0;
        }
        ScryersLinkageTile tile = (ScryersLinkageTile)be;
        Pair<Level, BlockPos> info = tile.getTargetInfo();
        if (info == null) {
            return 0;
        }
        Level targetLevel = (Level)info.first();
        BlockPos targetPos = (BlockPos)info.second();
        return targetLevel.getBlockState(targetPos).getDirectSignal((BlockGetter)targetLevel, targetPos, side);
    }

    protected boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    @Override
    public boolean hasAnalogOutputSignalGivenContext(LevelAccessor level, BlockPos pos, BlockState state, Direction side) {
        BlockPos targetPos;
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof ScryersLinkageTile)) {
            return false;
        }
        ScryersLinkageTile tile = (ScryersLinkageTile)be;
        Pair<Level, BlockPos> info = tile.getTargetInfo();
        if (info == null) {
            return false;
        }
        Level targetLevel = (Level)info.first();
        BlockState targetState = targetLevel.getBlockState(targetPos = (BlockPos)info.second());
        Block block = targetState.getBlock();
        if (block instanceof ContextualAnalogSignalling) {
            ContextualAnalogSignalling cas = (ContextualAnalogSignalling)block;
            return cas.hasAnalogOutputSignalGivenContext((LevelAccessor)targetLevel, targetPos, targetState, side);
        }
        return targetState.hasAnalogOutputSignal();
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof ScryersLinkageTile)) {
            return 0;
        }
        ScryersLinkageTile tile = (ScryersLinkageTile)be;
        Pair<Level, BlockPos> info = tile.getTargetInfo();
        if (info == null) {
            return 0;
        }
        Level targetLevel = (Level)info.first();
        BlockPos targetPos = (BlockPos)info.second();
        return targetLevel.getBlockState(targetPos).getAnalogOutputSignal(targetLevel, targetPos);
    }

    public boolean canConnectRedstone(@NotNull BlockState ignoredState, BlockGetter getter, @NotNull BlockPos pos, @Nullable Direction direction) {
        BlockEntity be = getter.getBlockEntity(pos);
        if (!(be instanceof ScryersLinkageTile)) {
            return false;
        }
        ScryersLinkageTile tile = (ScryersLinkageTile)be;
        Pair<Level, BlockPos> info = tile.getTargetInfo();
        if (info == null) {
            return false;
        }
        Level targetLevel = (Level)info.first();
        BlockPos targetPos = (BlockPos)info.second();
        BlockState state = targetLevel.getBlockState(targetPos);
        return state.getBlock().canConnectRedstone(state, (BlockGetter)targetLevel, targetPos, direction);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level ignoredLevel, @NotNull BlockState ignoredState, @NotNull BlockEntityType<T> ignoredType) {
        AtomicReference<WeakReference<ScryersLinkageTile>> be = new AtomicReference<WeakReference<ScryersLinkageTile>>(new WeakReference<ScryersLinkageTile>(null));
        AtomicInteger target = new AtomicInteger(-1);
        return (level, pos, state, type) -> {
            BlockEntity maybeBe;
            ScryersLinkageTile tile = (ScryersLinkageTile)((WeakReference)be.get()).get();
            if (tile == null && (maybeBe = level.getBlockEntity(pos)) instanceof ScryersLinkageTile) {
                ScryersLinkageTile tile2 = (ScryersLinkageTile)maybeBe;
                be.set(new WeakReference<ScryersLinkageTile>(tile2));
            }
            if ((tile = (ScryersLinkageTile)((WeakReference)be.get()).get()) != null) {
                if (!tile.hasTarget()) {
                    if (target.getAndSet(-1) != -1) {
                        tile.invalidateCapabilities();
                    }
                    return;
                }
                Pair<Level, BlockPos> info = tile.getTargetInfo();
                if (info == null) {
                    target.set(-1);
                    return;
                }
                int newBe = System.identityHashCode(((Level)info.first()).getBlockEntity((BlockPos)info.second()));
                if (target.getAndSet(newBe) != newBe) {
                    tile.invalidateCapabilities();
                }
                level.updateNeighborsAt(pos, state.getBlock());
                level.updateNeighbourForOutputSignal(pos, state.getBlock());
            }
        };
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState p_220053_1_, @NotNull BlockGetter p_220053_2_, @NotNull BlockPos p_220053_3_, @NotNull CollisionContext p_220053_4_) {
        return SHAPE;
    }

    static {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.0625, (double)0.0625, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0625, (double)0.0625, (double)0.1875, (double)0.1875, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)0.125, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.125, (double)0.0, (double)1.0, (double)0.25, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.0, (double)0.125, (double)1.0, (double)0.0625, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.0, (double)0.9375, (double)1.0, (double)0.0625, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.875, (double)1.0, (double)0.125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.9375, (double)0.875, (double)0.0625, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.125, (double)0.9375, (double)1.0, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.0, (double)0.75, (double)1.0, (double)0.0625, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.9375, (double)0.0625, (double)0.0625, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.875, (double)0.125, (double)0.125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.9375, (double)0.25, (double)0.0625, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.9375, (double)0.0625, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.75, (double)0.0625, (double)0.0625, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.9375, (double)0.0, (double)0.0625, (double)1.0, (double)0.061875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)0.0, (double)0.125, (double)1.0, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.9375, (double)0.0, (double)0.25, (double)1.0, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.0, (double)0.0625, (double)0.875, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.9375, (double)0.125, (double)0.0625, (double)0.9375, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.9375, (double)0.0, (double)1.0, (double)1.0, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.9375, (double)0.0, (double)0.875, (double)1.0, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.75, (double)0.0, (double)1.0, (double)0.875, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.9375, (double)0.125, (double)1.0, (double)1.0, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.9375, (double)0.9375, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.875, (double)0.875, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.9375, (double)0.9375, (double)0.875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.75, (double)0.9375, (double)1.0, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.9375, (double)0.75, (double)1.0, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.9375, (double)0.9375, (double)0.0625, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)0.875, (double)0.125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.9375, (double)0.9375, (double)0.25, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.9375, (double)0.0625, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.9375, (double)0.75, (double)0.0625, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.0625, (double)0.8125, (double)0.9375, (double)0.1875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0625, (double)0.8125, (double)0.1875, (double)0.1875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.8125, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.8125, (double)0.8125, (double)0.8125, (double)0.9375, (double)0.9375, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.8125, (double)0.0625, (double)0.1875, (double)0.9375, (double)0.1875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.8125, (double)0.8125, (double)0.1875, (double)0.9375, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.9375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.063125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.9375, (double)0.125, (double)0.0625, (double)1.0, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.9375, (double)0.125, (double)0.0625, (double)1.0, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.0, (double)0.125, (double)0.0625, (double)1.0, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.0, (double)0.125, (double)0.0625, (double)1.0, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.0, (double)0.25, (double)0.0625, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.0, (double)0.0625, (double)0.25, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.125, (double)0.0625, (double)0.0625, (double)0.25), (BooleanOp)BooleanOp.OR);
        SHAPE = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.0, (double)0.875, (double)0.0625, (double)0.0625), (BooleanOp)BooleanOp.OR);
    }
}

