/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.integration.curios;

import artifacts.equipment.EquipmentSlotProvider;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosSlotProvider
implements EquipmentSlotProvider {
    @Override
    public <T> T reduceEquipment(LivingEntity entity, T init, BiFunction<ItemStack, T, T> f) {
        Optional itemHandler = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (itemHandler.isPresent()) {
            for (ICurioStacksHandler stacksHandler : ((ICuriosItemHandler)itemHandler.get()).getCurios().values()) {
                for (int i = 0; i < stacksHandler.getStacks().getSlots(); ++i) {
                    ItemStack item = stacksHandler.getStacks().getStackInSlot(i);
                    if (item.isEmpty()) continue;
                    init = f.apply(item, (ItemStack)init);
                }
            }
        }
        return init;
    }

    @Override
    public boolean tryEquipItem(LivingEntity entity, ItemStack stack) {
        Optional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (optional.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)optional.get();
            for (Map.Entry entry : handler.getCurios().entrySet()) {
                for (int i = 0; i < ((ICurioStacksHandler)entry.getValue()).getSlots(); ++i) {
                    SlotContext slotContext = new SlotContext((String)entry.getKey(), entity, i, false, true);
                    if (!CuriosApi.isStackValid((SlotContext)slotContext, (ItemStack)stack) || !((ICurioStacksHandler)entry.getValue()).getStacks().getStackInSlot(i).isEmpty()) continue;
                    ((ICurioStacksHandler)entry.getValue()).getStacks().setStackInSlot(i, stack);
                    return true;
                }
            }
        }
        return false;
    }
}

