/*
 * Decompiled with CFR 0.152.
 */
package artifacts.loot;

import artifacts.Artifacts;
import artifacts.registry.ModLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record ConfigValueChance(ChanceConfig chanceConfig) implements LootItemCondition
{
    public static final MapCodec<ConfigValueChance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChanceConfig.CODEC.fieldOf("config").forGetter(c -> c.chanceConfig)).apply((Applicative)instance, ConfigValueChance::new));

    public LootItemConditionType getType() {
        return (LootItemConditionType)ModLootConditions.CONFIG_VALUE_CHANCE.value();
    }

    public boolean test(LootContext context) {
        return context.getRandom().nextDouble() < this.chanceConfig.value.get();
    }

    public static LootItemCondition.Builder archaeologyChance() {
        return () -> new ConfigValueChance(ChanceConfig.ARCHAEOLOGY);
    }

    public static LootItemCondition.Builder entityEquipmentChance() {
        return () -> new ConfigValueChance(ChanceConfig.ENTITY_EQUIPMENT);
    }

    public static LootItemCondition.Builder everlastingBeefChance() {
        return () -> new ConfigValueChance(ChanceConfig.EVERLASTING_BEEF);
    }

    private static enum ChanceConfig implements StringRepresentable
    {
        ARCHAEOLOGY("archaeology", Artifacts.CONFIG.general.archaeologyChance),
        ENTITY_EQUIPMENT("entity_equipment", Artifacts.CONFIG.general.entityEquipmentChance),
        EVERLASTING_BEEF("everlasting_beef", Artifacts.CONFIG.items.everlastingBeefDropRate);

        private static final Codec<ChanceConfig> CODEC;
        final String name;
        final Supplier<Double> value;

        private ChanceConfig(String name, Supplier<Double> value) {
            this.name = name;
            this.value = value;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ChanceConfig::values);
        }
    }
}

