/*
 * Decompiled with CFR 0.152.
 */
package artifacts.config.value;

import artifacts.config.value.type.ValueType;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;

public interface Value<T>
extends Supplier<T> {
    public static <T> Value<T> of(T v) {
        return new Constant<T>(v);
    }

    public record Constant<T>(T get) implements Value<T>
    {
    }

    public static final class ConfigValue<T>
    implements Value<T>,
    StringRepresentable {
        private final ValueType<T, ?> type;
        private final String id;
        private final T defaultValue;
        private final boolean requiresRestart;
        private T value;

        public ConfigValue(ValueType<T, ?> type, String id, T defaultValue) {
            this(type, id, defaultValue, false);
        }

        public ConfigValue(ValueType<T, ?> type, String id, T defaultValue, boolean requiresRestart) {
            this.type = type;
            this.id = id;
            this.requiresRestart = requiresRestart;
            this.value = defaultValue;
            this.defaultValue = this.value;
        }

        public String getId() {
            return this.id;
        }

        public String getSerializedName() {
            return this.getId();
        }

        @Override
        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public ValueType<T, ?> type() {
            return this.type;
        }

        public boolean requiresRestart() {
            return this.requiresRestart;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConfigValue)) {
                return false;
            }
            ConfigValue that = (ConfigValue)o;
            return this.type.equals(that.type) && this.getId().equals(that.getId()) && this.getDefaultValue().equals(that.getDefaultValue());
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.getId().hashCode();
            result = 31 * result + this.getDefaultValue().hashCode();
            return result;
        }
    }
}

