/*
 * Decompiled with CFR 0.152.
 */
package observable.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.SplitPacketTransformer;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import observable.shadow.kotlinx.serialization.protobuf.ProtoBuf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\n\u0018\u0000 -2\u00020\u0001:\u0002-.B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u000b\u001a\u00020\n\"\u0006\b\u0000\u0010\u0006\u0018\u00012\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\bH\u0086\b\u00a2\u0006\u0004\b\u000b\u0010\fJ7\u0010\u0011\u001a\u00020\u000f\"\u0006\b\u0000\u0010\u0006\u0018\u00012\u001a\b\b\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J(\u0010\u0016\u001a\u00020\u000f\"\u0006\b\u0000\u0010\u0006\u0018\u00012\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00028\u0000H\u0086\b\u00a2\u0006\u0004\b\u0016\u0010\u0017J.\u0010\u001a\u001a\u00020\u000f\"\u0006\b\u0000\u0010\u0006\u0018\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u0006\u0010\u0015\u001a\u00028\u0000H\u0086\b\u00a2\u0006\u0004\b\u001a\u0010\u001bJ.\u0010\u001c\u001a\u00020\u000f\"\u0006\b\u0000\u0010\u0006\u0018\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u0006\u0010\u0015\u001a\u00028\u0000H\u0086\b\u00a2\u0006\u0004\b\u001c\u0010\u001bJ \u0010\u001d\u001a\u00020\u000f\"\u0006\b\u0000\u0010\u0006\u0018\u00012\u0006\u0010\u0015\u001a\u00028\u0000H\u0086\b\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R5\u0010&\u001a \u0012\u0004\u0012\u00020$\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0#8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b*\u0010\"R\u0017\u0010+\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b+\u0010 \u001a\u0004\b,\u0010\"\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006/"}, d2={"Lobservable/net/BetterChannel;", "", "Lnet/minecraft/resources/ResourceLocation;", "id", "<init>", "(Lnet/minecraft/resources/ResourceLocation;)V", "T", "data", "Ldev/architectury/networking/NetworkManager$Side;", "side", "Lobservable/net/BetterChannel$SerializedPayload;", "createPayload", "(Ljava/lang/Object;Ldev/architectury/networking/NetworkManager$Side;)Lobservable/net/BetterChannel$SerializedPayload;", "Lkotlin/Function2;", "Ldev/architectury/networking/NetworkManager$PacketContext;", "", "consumer", "register", "(Lkotlin/jvm/functions/Function2;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "msg", "sendToPlayer", "(Lnet/minecraft/server/level/ServerPlayer;Ljava/lang/Object;)V", "", "players", "sendToPlayers", "(Ljava/lang/Iterable;Ljava/lang/Object;)V", "sendToPlayersSplit", "sendToServer", "(Ljava/lang/Object;)V", "c2sLocation", "Lnet/minecraft/resources/ResourceLocation;", "getC2sLocation", "()Lnet/minecraft/resources/ResourceLocation;", "", "", "", "handlers", "Ljava/util/Map;", "getHandlers", "()Ljava/util/Map;", "getId", "s2cLocation", "getS2cLocation", "Companion", "SerializedPayload", "observable"})
@SourceDebugExtension(value={"SMAP\nBetterChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BetterChannel.kt\nobservable/net/BetterChannel\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n34#1:88\n74#1:90\n75#1:93\n77#1:95\n34#1:96\n73#1,6:98\n74#1:104\n75#1:107\n77#1:109\n34#1:110\n73#1,6:112\n34#1:118\n186#2:84\n186#2:89\n186#2:97\n186#2:111\n186#2:119\n766#3:85\n857#3,2:86\n766#3:91\n857#3:92\n858#3:94\n766#3:105\n857#3:106\n858#3:108\n*S KotlinDebug\n*F\n+ 1 BetterChannel.kt\nobservable/net/BetterChannel\n*L\n77#1:88\n79#1:90\n79#1:93\n79#1:95\n79#1:96\n79#1:98,6\n80#1:104\n80#1:107\n80#1:109\n80#1:110\n80#1:112,6\n81#1:118\n34#1:84\n77#1:89\n79#1:97\n80#1:111\n81#1:119\n74#1:85\n74#1:86,2\n79#1:91\n79#1:92\n79#1:94\n80#1:105\n80#1:106\n80#1:108\n*E\n"})
public final class BetterChannel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private final ResourceLocation s2cLocation;
    @NotNull
    private final ResourceLocation c2sLocation;
    @NotNull
    private final Map<String, Function2<byte[], NetworkManager.PacketContext, Unit>> handlers;
    private static final Logger LOGGER = LogManager.getLogger((String)"ObservableNet");

    public BetterChannel(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        ResourceLocation resourceLocation = this.id.withSuffix("-s2c");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"withSuffix(...)");
        this.s2cLocation = resourceLocation;
        ResourceLocation resourceLocation2 = this.id.withSuffix("-c2s");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"withSuffix(...)");
        this.c2sLocation = resourceLocation2;
        this.handlers = new LinkedHashMap();
        StreamCodec<RegistryFriendlyByteBuf, SerializedPayload> codec2 = new StreamCodec<RegistryFriendlyByteBuf, SerializedPayload>(this){
            final /* synthetic */ BetterChannel this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public SerializedPayload decode(@NotNull RegistryFriendlyByteBuf buf) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                String name = buf.readUtf();
                Closeable closeable = new GZIPInputStream(new ByteArrayInputStream(buf.readByteArray()));
                int n = 8192;
                closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                Throwable throwable = null;
                try {
                    BufferedInputStream it = (BufferedInputStream)closeable;
                    boolean bl = false;
                    byArray = it.readAllBytes();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                byte[] bytes = byArray;
                Intrinsics.checkNotNull((Object)name);
                Intrinsics.checkNotNull((Object)bytes);
                return new SerializedPayload(name, bytes, this.this$0.getId());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull SerializedPayload payload) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                buf.writeUtf(payload.getClassName());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Closeable closeable = new GZIPOutputStream(bos);
                int n = 8192;
                closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
                Throwable throwable = null;
                try {
                    BufferedOutputStream it = (BufferedOutputStream)closeable;
                    boolean bl = false;
                    it.write(payload.getData());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                buf.writeByteArray(bos.toByteArray());
            }
        };
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType((CustomPacketPayload.Type)new CustomPacketPayload.Type(this.s2cLocation), (StreamCodec)((StreamCodec)codec2), (List)CollectionsKt.listOf((Object)new SplitPacketTransformer()));
        } else {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (CustomPacketPayload.Type)new CustomPacketPayload.Type(this.s2cLocation), (StreamCodec)((StreamCodec)codec2), (List)CollectionsKt.listOf((Object)new SplitPacketTransformer()), (arg_0, arg_1) -> BetterChannel._init_$lambda$0(this, arg_0, arg_1));
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (CustomPacketPayload.Type)new CustomPacketPayload.Type(this.c2sLocation), (StreamCodec)((StreamCodec)codec2), (arg_0, arg_1) -> BetterChannel._init_$lambda$1(this, arg_0, arg_1));
    }

    @NotNull
    public final ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public final ResourceLocation getS2cLocation() {
        return this.s2cLocation;
    }

    @NotNull
    public final ResourceLocation getC2sLocation() {
        return this.c2sLocation;
    }

    public final /* synthetic */ <T> SerializedPayload createPayload(T data, NetworkManager.Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        boolean $i$f$createPayload = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        BinaryFormat $this$encodeToByteArray$iv = ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule serializersModule = $this$encodeToByteArray$iv.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return new SerializedPayload(string, $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), data), side == NetworkManager.Side.S2C ? this.getS2cLocation() : this.getC2sLocation());
    }

    @NotNull
    public final Map<String, Function2<byte[], NetworkManager.PacketContext, Unit>> getHandlers() {
        return this.handlers;
    }

    public final /* synthetic */ <T> void register(Function2<? super T, ? super NetworkManager.PacketContext, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        boolean $i$f$register = false;
        Map<String, Function2<byte[], NetworkManager.PacketContext, Unit>> map = this.getHandlers();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        Intrinsics.needClassReification();
        Function2<byte[], NetworkManager.PacketContext, Unit> function2 = new Function2<byte[], NetworkManager.PacketContext, Unit>(consumer){
            final /* synthetic */ Function2<T, NetworkManager.PacketContext, Unit> $consumer;
            {
                this.$consumer = $consumer;
                super(2);
            }

            public final void invoke(@NotNull byte[] buf, @NotNull NetworkManager.PacketContext ctx) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                BinaryFormat $this$decodeFromByteArray$iv = ProtoBuf.Default;
                boolean $i$f$decodeFromByteArray = false;
                SerializersModule serializersModule = $this$decodeFromByteArray$iv.getSerializersModule();
                Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                this.$consumer.invoke($this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), buf), (Object)ctx);
            }
        };
        map.put(string2, function2);
        Logger logger = Companion.getLOGGER();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        logger.info("Registered " + Object.class);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> void sendToPlayers(Iterable<? extends ServerPlayer> players, T msg) {
        void this_$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(players, (String)"players");
        boolean $i$f$sendToPlayers = false;
        Object $this$filter$iv = players;
        boolean $i$f$filter = false;
        Iterable<? extends ServerPlayer> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerPlayer it = (ServerPlayer)element$iv$iv;
            boolean bl = false;
            if (!NetworkManager.canPlayerReceive((ServerPlayer)it, (ResourceLocation)this.getS2cLocation())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        $this$filter$iv = this;
        NetworkManager.Side side$iv = NetworkManager.Side.S2C;
        boolean $i$f$createPayload = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        BinaryFormat $this$encodeToByteArray$iv$iv = ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule serializersModule = $this$encodeToByteArray$iv$iv.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        NetworkManager.sendToPlayers((Iterable)iterable2, (CustomPacketPayload)new SerializedPayload(string, $this$encodeToByteArray$iv$iv.encodeToByteArray((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), msg), side$iv == NetworkManager.Side.S2C ? this_$iv.getS2cLocation() : this_$iv.getC2sLocation()));
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> void sendToPlayer(ServerPlayer player, T msg) {
        void this_$iv$iv;
        void this_$iv;
        void $this$filterTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean $i$f$sendToPlayer = false;
        BetterChannel betterChannel = this;
        Iterable players$iv = CollectionsKt.listOf((Object)player);
        boolean $i$f$sendToPlayers = false;
        Iterable $this$filter$iv$iv = players$iv;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            ServerPlayer it$iv = (ServerPlayer)element$iv$iv$iv;
            boolean bl = false;
            if (!NetworkManager.canPlayerReceive((ServerPlayer)it$iv, (ResourceLocation)this_$iv.getS2cLocation())) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv$iv;
        $this$filter$iv$iv = this_$iv;
        NetworkManager.Side side$iv$iv = NetworkManager.Side.S2C;
        boolean $i$f$createPayload = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        BinaryFormat $this$encodeToByteArray$iv$iv$iv = ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule serializersModule = $this$encodeToByteArray$iv$iv$iv.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        NetworkManager.sendToPlayers((Iterable)iterable2, (CustomPacketPayload)new SerializedPayload(string, $this$encodeToByteArray$iv$iv$iv.encodeToByteArray((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), msg), side$iv$iv == NetworkManager.Side.S2C ? this_$iv$iv.getS2cLocation() : this_$iv$iv.getC2sLocation()));
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> void sendToPlayersSplit(Iterable<? extends ServerPlayer> players, T msg) {
        void this_$iv$iv;
        void $this$filterTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter(players, (String)"players");
        boolean $i$f$sendToPlayersSplit = false;
        BetterChannel this_$iv = this;
        boolean $i$f$sendToPlayers = false;
        Object $this$filter$iv$iv = players;
        boolean $i$f$filter = false;
        Iterable<? extends ServerPlayer> iterable = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            ServerPlayer it$iv = (ServerPlayer)element$iv$iv$iv;
            boolean bl = false;
            if (!NetworkManager.canPlayerReceive((ServerPlayer)it$iv, (ResourceLocation)this_$iv.getS2cLocation())) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv$iv;
        $this$filter$iv$iv = this_$iv;
        NetworkManager.Side side$iv$iv = NetworkManager.Side.S2C;
        boolean $i$f$createPayload = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        BinaryFormat $this$encodeToByteArray$iv$iv$iv = ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule serializersModule = $this$encodeToByteArray$iv$iv$iv.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        NetworkManager.sendToPlayers((Iterable)iterable2, (CustomPacketPayload)new SerializedPayload(string, $this$encodeToByteArray$iv$iv$iv.encodeToByteArray((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), msg), side$iv$iv == NetworkManager.Side.S2C ? this_$iv$iv.getS2cLocation() : this_$iv$iv.getC2sLocation()));
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> void sendToServer(T msg) {
        void this_$iv;
        boolean $i$f$sendToServer = false;
        BetterChannel betterChannel = this;
        NetworkManager.Side side$iv = NetworkManager.Side.C2S;
        boolean $i$f$createPayload = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        BinaryFormat $this$encodeToByteArray$iv$iv = ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule serializersModule = $this$encodeToByteArray$iv$iv.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        NetworkManager.sendToServer((CustomPacketPayload)new SerializedPayload(string, $this$encodeToByteArray$iv$iv.encodeToByteArray((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), msg), side$iv == NetworkManager.Side.S2C ? this_$iv.getS2cLocation() : this_$iv.getC2sLocation()));
    }

    private static final void _init_$lambda$0(BetterChannel this$0, SerializedPayload value, NetworkManager.PacketContext ctx) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Function2<byte[], NetworkManager.PacketContext, Unit> function2 = this$0.handlers.get(value.getClassName());
            if (function2 == null) break block0;
            byte[] byArray = value.getData();
            Intrinsics.checkNotNull((Object)ctx);
            function2.invoke((Object)byArray, (Object)ctx);
        }
    }

    private static final void _init_$lambda$1(BetterChannel this$0, SerializedPayload value, NetworkManager.PacketContext ctx) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ctx.getPlayer();
            Function2<byte[], NetworkManager.PacketContext, Unit> function2 = this$0.handlers.get(value.getClassName());
            if (function2 == null) break block0;
            byte[] byArray = value.getData();
            Intrinsics.checkNotNull((Object)ctx);
            function2.invoke((Object)byArray, (Object)ctx);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lobservable/net/BetterChannel$Companion;", "", "<init>", "()V", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "observable"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lobservable/net/BetterChannel$SerializedPayload;", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "", "className", "", "data", "Lnet/minecraft/resources/ResourceLocation;", "location", "<init>", "(Ljava/lang/String;[BLnet/minecraft/resources/ResourceLocation;)V", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "type", "()Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Ljava/lang/String;", "getClassName", "()Ljava/lang/String;", "[B", "getData", "()[B", "Lnet/minecraft/resources/ResourceLocation;", "getLocation", "()Lnet/minecraft/resources/ResourceLocation;", "observable"})
    public static final class SerializedPayload
    implements CustomPacketPayload {
        @NotNull
        private final String className;
        @NotNull
        private final byte[] data;
        @NotNull
        private final ResourceLocation location;

        public SerializedPayload(@NotNull String className, @NotNull byte[] data, @NotNull ResourceLocation location) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            this.className = className;
            this.data = data;
            this.location = location;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        @NotNull
        public final ResourceLocation getLocation() {
            return this.location;
        }

        @NotNull
        public CustomPacketPayload.Type<CustomPacketPayload> type() {
            return new CustomPacketPayload.Type(this.location);
        }
    }
}

