/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.mojang.brigadier.StringReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.kubejs.codec.KubeJSCodecs;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import io.netty.buffer.ByteBuf;
import java.util.regex.Pattern;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public interface RegExpKJS {
    public static final Codec<Pattern> CODEC = KubeJSCodecs.stringResolverCodec(RegExpKJS::toRegExpString, RegExpKJS::wrap);
    public static final StreamCodec<ByteBuf, Pattern> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(RegExpKJS::wrap, RegExpKJS::toRegExpString);

    @Nullable
    public static Pattern wrap(Object o) {
        if (o instanceof CharSequence || o instanceof NativeRegExp) {
            return RegExpKJS.ofString(o.toString());
        }
        if (o instanceof Pattern) {
            Pattern pattern = (Pattern)o;
            return pattern;
        }
        return null;
    }

    public static int getFlags(String f) {
        int flags = 0;
        block9: for (int i = 0; i < f.length(); ++i) {
            switch (f.charAt(i)) {
                case 'd': {
                    flags |= 1;
                    continue block9;
                }
                case 'i': {
                    flags |= 2;
                    continue block9;
                }
                case 'x': {
                    flags |= 4;
                    continue block9;
                }
                case 'm': {
                    flags |= 8;
                    continue block9;
                }
                case 's': {
                    flags |= 0x20;
                    continue block9;
                }
                case 'u': {
                    flags |= 0x40;
                    continue block9;
                }
                case 'U': {
                    flags |= 0x100;
                }
            }
        }
        return flags;
    }

    public static boolean isValidFlag(char c) {
        return c == 'd' || c == 'i' || c == 'x' || c == 'm' || c == 's' || c == 'u' || c == 'U';
    }

    @Nullable
    public static Pattern ofString(String string) {
        if (string.length() < 3 || string.charAt(0) != '/') {
            return null;
        }
        return RegExpKJS.read(new StringReader(string));
    }

    public static String toRegExpString(Pattern pattern) {
        StringBuilder sb = new StringBuilder("/");
        sb.append(pattern.pattern());
        sb.append('/');
        int flags = pattern.flags();
        if ((flags & 1) != 0) {
            sb.append('d');
        }
        if ((flags & 2) != 0) {
            sb.append('i');
        }
        if ((flags & 4) != 0) {
            sb.append('x');
        }
        if ((flags & 8) != 0) {
            sb.append('m');
        }
        if ((flags & 0x20) != 0) {
            sb.append('s');
        }
        if ((flags & 0x40) != 0) {
            sb.append('u');
        }
        if ((flags & 0x100) != 0) {
            sb.append('U');
        }
        return sb.toString();
    }

    public static Pattern read(StringReader reader) {
        if (!reader.canRead() || reader.peek() != '/') {
            throw new IllegalArgumentException("RegExp must start with /");
        }
        reader.skip();
        StringBuilder pattern = new StringBuilder();
        while (reader.canRead()) {
            char c = reader.read();
            if (c == '\\' && reader.canRead() && reader.peek() == '/') {
                reader.skip();
                pattern.append('/');
                continue;
            }
            if (c == '/') break;
            pattern.append(c);
        }
        StringBuilder flags = new StringBuilder(0);
        while (reader.canRead() && RegExpKJS.isValidFlag(reader.peek())) {
            flags.append(reader.read());
        }
        return Pattern.compile(pattern.toString(), RegExpKJS.getFlags(flags.toString()));
    }

    public static DataResult<Pattern> tryRead(StringReader reader) {
        try {
            return DataResult.success((Object)RegExpKJS.read(reader));
        }
        catch (IllegalArgumentException ex) {
            return DataResult.error(() -> "Failed to parse regex from string: " + String.valueOf(ex));
        }
    }
}

