/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.latvian.mods.kubejs.level.ExplosionKubeEvent;
import dev.latvian.mods.kubejs.level.SimpleLevelKubeEvent;
import dev.latvian.mods.kubejs.plugin.builtin.event.LevelEvents;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="kubejs")
public class KubeJSWorldEventHandler {
    @SubscribeEvent
    public static void serverLevelLoad(LevelEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && LevelEvents.LOADED.hasListeners((ResourceKey<Level>)(level = (ServerLevel)levelAccessor).dimension())) {
            LevelEvents.LOADED.post(new SimpleLevelKubeEvent((Level)level), (ResourceKey<Level>)level.dimension());
        }
    }

    @SubscribeEvent
    public static void serverLevelUnload(LevelEvent.Unload event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && LevelEvents.UNLOADED.hasListeners((ResourceKey<Level>)(level = (ServerLevel)levelAccessor).dimension())) {
            LevelEvents.UNLOADED.post(new SimpleLevelKubeEvent((Level)level), (ResourceKey<Level>)level.dimension());
        }
    }

    @SubscribeEvent
    public static void serverTickEvent(LevelTickEvent.Post event) {
        ServerLevel level;
        Level level2 = event.getLevel();
        if (level2 instanceof ServerLevel && LevelEvents.TICK.hasListeners((ResourceKey<Level>)(level = (ServerLevel)level2).dimension())) {
            LevelEvents.TICK.post(ScriptType.SERVER, (ResourceKey<Level>)level.dimension(), new SimpleLevelKubeEvent((Level)level));
        }
    }

    @SubscribeEvent
    public static void preExplosion(ExplosionEvent.Start event) {
        ServerLevel level;
        Level level2 = event.getLevel();
        if (level2 instanceof ServerLevel && LevelEvents.BEFORE_EXPLOSION.hasListeners((ResourceKey<Level>)(level = (ServerLevel)level2).dimension())) {
            LevelEvents.BEFORE_EXPLOSION.post((ScriptTypeHolder)level, (ResourceKey<Level>)level.dimension(), new ExplosionKubeEvent.Before((Level)level, event.getExplosion())).applyCancel((ICancellableEvent)event);
        }
    }

    @SubscribeEvent
    public static void detonateExplosion(ExplosionEvent.Detonate event) {
        ServerLevel level;
        Level level2 = event.getLevel();
        if (level2 instanceof ServerLevel && LevelEvents.AFTER_EXPLOSION.hasListeners((ResourceKey<Level>)(level = (ServerLevel)level2).dimension())) {
            LevelEvents.AFTER_EXPLOSION.post((ScriptTypeHolder)level, (ResourceKey<Level>)level.dimension(), new ExplosionKubeEvent.After((Level)level, event.getExplosion(), event.getAffectedEntities()));
        }
    }
}

