/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.entity;

import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.entity.KubeLivingEntityEvent;
import dev.latvian.mods.kubejs.level.LevelBlock;
import dev.latvian.mods.kubejs.level.WrappedSpawner;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Info(value="Invoked before an entity is spawned into the world.\n\nOnly entities from a `BaseSpawner` or world generation will trigger this event.\n")
public class CheckLivingEntitySpawnKubeEvent
implements KubeLivingEntityEvent {
    private final LivingEntity entity;
    private final Level level;
    public final double x;
    public final double y;
    public final double z;
    public final transient MobSpawnType type;
    private final Either<BlockEntity, Entity> spawnerEither;
    @Nullable
    public transient WrappedSpawner spawner;

    public CheckLivingEntitySpawnKubeEvent(LivingEntity entity, Level level, double x, double y, double z, MobSpawnType type, Either<BlockEntity, Entity> spawnerEither) {
        this.entity = entity;
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
        this.spawnerEither = spawnerEither;
    }

    @Override
    @Info(value="The level the entity is being spawned into.")
    public Level getLevel() {
        return this.level;
    }

    @Override
    @Info(value="The entity being spawned.")
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Info(value="The block the entity is being spawned on.")
    public LevelBlock getBlock() {
        return this.level.kjs$getBlock(BlockPos.containing((double)this.x, (double)this.y, (double)this.z));
    }

    @Info(value="The type of spawn.")
    public MobSpawnType getType() {
        return this.type;
    }

    @Info(value="The spawner that spawned the entity.")
    @NotNull
    public WrappedSpawner getSpawner() {
        if (this.spawner == null) {
            this.spawner = WrappedSpawner.of(this.spawnerEither);
        }
        return this.spawner;
    }
}

