/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.items;

import com.direwolf20.laserio.common.containers.CardHolderContainer;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.upgrades.OverclockerCard;
import com.direwolf20.laserio.common.items.upgrades.OverclockerNode;
import com.direwolf20.laserio.setup.LaserIODataComponents;
import com.direwolf20.laserio.util.CardHolderItemStackHandler;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import org.jetbrains.annotations.NotNull;

public class CardHolder
extends Item {
    public CardHolder() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (player.isShiftKeyDown()) {
            CardHolder.setActive(itemstack, !CardHolder.getActive(itemstack));
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CardHolderContainer(windowId, playerInventory, player, itemstack), (Component)Component.translatable((String)"")), buf -> ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemstack));
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public boolean isFoil(ItemStack itemStack) {
        return CardHolder.getActive(itemStack);
    }

    public CardHolderItemStackHandler getItemHandler(ItemStack stack) {
        return new CardHolderItemStackHandler(15, stack);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (CardHolder.getActive(stack)) {
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack cardStack = player.getInventory().getItem(i);
                    if (!(cardStack.getItem() instanceof BaseCard) && !(cardStack.getItem() instanceof BaseFilter) && !(cardStack.getItem() instanceof OverclockerCard) && !(cardStack.getItem() instanceof OverclockerNode)) continue;
                    CardHolder.addCardToInventory(stack, cardStack);
                }
            }
        }
    }

    public static ItemStack addCardToInventory(ItemStack cardHolder, ItemStack card) {
        if (card.getItem() instanceof BaseFilter && !card.isComponentsPatchEmpty()) {
            return card;
        }
        ComponentItemHandler handler = new ComponentItemHandler((MutableDataComponentHolder)cardHolder, (DataComponentType)LaserIODataComponents.ITEMSTACK_HANDLER.get(), 15);
        if (handler == null) {
            return card;
        }
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            int maxSize;
            ItemStack stackInSlot = handler.getStackInSlot(i);
            if (stackInSlot.isEmpty()) {
                emptySlots.add(i);
            }
            if (stackInSlot.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)card)) continue;
            int j = stackInSlot.getCount() + card.getCount();
            if (j <= (maxSize = 64)) {
                card.setCount(0);
                stackInSlot.setCount(j);
                handler.setStackInSlot(i, stackInSlot);
            } else if (stackInSlot.getCount() < maxSize) {
                card.shrink(maxSize - stackInSlot.getCount());
                stackInSlot.setCount(maxSize);
                handler.setStackInSlot(i, stackInSlot);
            }
            if (!card.isEmpty()) continue;
            return card;
        }
        if (emptySlots.isEmpty()) {
            return card;
        }
        handler.insertItem(((Integer)emptySlots.get(0)).intValue(), card.split(card.getCount()), false);
        return card;
    }

    public static UUID getUUID(ItemStack stack) {
        if (!stack.has(LaserIODataComponents.CARD_HOLDER_UUID)) {
            UUID newId = UUID.randomUUID();
            stack.set(LaserIODataComponents.CARD_HOLDER_UUID, (Object)newId);
            return newId;
        }
        return (UUID)stack.get(LaserIODataComponents.CARD_HOLDER_UUID);
    }

    public static boolean getActive(ItemStack stack) {
        return (Boolean)stack.getOrDefault(LaserIODataComponents.CARD_HOLDER_ACTIVE, (Object)false);
    }

    public static boolean setActive(ItemStack stack, boolean active) {
        if (!active) {
            stack.remove(LaserIODataComponents.CARD_HOLDER_ACTIVE);
        } else {
            stack.set(LaserIODataComponents.CARD_HOLDER_ACTIVE, (Object)active);
        }
        return active;
    }
}

