/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.net;

import de.maxhenkel.easyvillagers.corelib.net.Message;
import de.maxhenkel.easyvillagers.events.VillagerEvents;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessagePickUpVillager
implements Message<MessagePickUpVillager> {
    public static final CustomPacketPayload.Type<MessagePickUpVillager> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"easy_villagers", (String)"pick_up_villager"));
    private UUID villager;

    public MessagePickUpVillager(UUID villager) {
        this.villager = villager;
    }

    public MessagePickUpVillager() {
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        sender.level().getEntitiesOfClass(Villager.class, sender.getBoundingBox().inflate(8.0), v -> v.getUUID().equals(this.villager)).stream().filter(VillagerEvents::arePickupConditionsMet).findAny().ifPresent(villagerEntity -> VillagerEvents.pickUp(villagerEntity, (Player)sender));
    }

    @Override
    public MessagePickUpVillager fromBytes(RegistryFriendlyByteBuf packetBuffer) {
        this.villager = packetBuffer.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf packetBuffer) {
        packetBuffer.writeUUID(this.villager);
    }

    @Override
    public CustomPacketPayload.Type<MessagePickUpVillager> type() {
        return TYPE;
    }
}

