/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.integration.jei;

import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.integration.jei.breeder.BreederCategory;
import de.maxhenkel.easyvillagers.integration.jei.converter.ConverterCategory;
import de.maxhenkel.easyvillagers.integration.jei.incubator.IncubatorCategory;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final RecipeType<ItemStack> CATEGORY_BREEDING = RecipeType.create((String)"easy_villagers", (String)"breeding", ItemStack.class);
    public static final RecipeType<ItemStack> CATEGORY_CONVERTING = RecipeType.create((String)"easy_villagers", (String)"converting", ItemStack.class);
    public static final RecipeType<ItemStack> CATEGORY_INCUBATING = RecipeType.create((String)"easy_villagers", (String)"incubating", ItemStack.class);

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"easy_villagers", (String)"easy_villagers");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.BREEDER.get()), new RecipeType[]{CATEGORY_BREEDING});
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CONVERTER.get()), new RecipeType[]{CATEGORY_CONVERTING});
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.INCUBATOR.get()), new RecipeType[]{CATEGORY_INCUBATING});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new BreederCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ConverterCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new IncubatorCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<ItemStack> foods = Villager.FOOD_POINTS.entrySet().stream().map(itemIntegerEntry -> new ItemStack((ItemLike)itemIntegerEntry.getKey(), (int)Math.ceil(24.0 / (double)((Integer)itemIntegerEntry.getValue()).intValue()))).toList();
        registration.addRecipes(CATEGORY_BREEDING, foods);
        ArrayList<ItemStack> potions = new ArrayList<ItemStack>();
        potions.add(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WEAKNESS));
        potions.add(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_WEAKNESS));
        potions.add(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.WEAKNESS));
        potions.add(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Potions.LONG_WEAKNESS));
        potions.add(PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)Potions.WEAKNESS));
        potions.add(PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)Potions.LONG_WEAKNESS));
        registration.addRecipes(CATEGORY_CONVERTING, potions);
        registration.addRecipes(CATEGORY_INCUBATING, Collections.singletonList(VillagerItem.createBabyVillager()));
    }
}

