/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.TraderBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.AutoTraderTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.corelib.client.CustomRendererBlockItem;
import de.maxhenkel.easyvillagers.corelib.client.ItemRenderer;
import de.maxhenkel.easyvillagers.datacomponents.VillagerBlockEntityData;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.AutoTraderContainer;
import de.maxhenkel.easyvillagers.items.render.AutoTraderItemRenderer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AutoTraderBlock
extends TraderBlockBase {
    @Override
    public Item toItem() {
        return new CustomRendererBlockItem(this, this, new Item.Properties()){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public ItemRenderer createItemRenderer() {
                return new AutoTraderItemRenderer();
            }
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, components, tooltipFlag);
        AutoTraderTileentity trader = VillagerBlockEntityData.getAndStoreBlockEntity(stack, context.registries(), context.level(), () -> new AutoTraderTileentity(BlockPos.ZERO, ((AutoTraderBlock)ModBlocks.AUTO_TRADER.get()).defaultBlockState()));
        EasyVillagerEntity villager = trader.getVillagerEntity();
        if (villager != null) {
            components.add(villager.getAdvancedName());
        }
    }

    @Override
    protected boolean openGUI(final TraderTileentityBase trader, Player player, final Level level, final BlockPos pos) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)"block.easy_villagers.auto_trader");
            }

            @Nullable
            public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
                AutoTraderTileentity autoTrader = (AutoTraderTileentity)trader;
                return new AutoTraderContainer(id, inv, autoTrader, autoTrader.getInputInventory(), autoTrader.getOutputInventory(), ContainerLevelAccess.create((Level)level, (BlockPos)pos));
            }
        });
        return true;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AutoTraderTileentity(blockPos, blockState);
    }
}

