/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.arsocultas.data.recipe;

import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ImbuementRecipeProvider;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.mojang.serialization.Codec;
import com.mystchonky.arsocultas.data.DataProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ImbuementProvider
extends ImbuementRecipeProvider {
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;

    public ImbuementProvider(CompletableFuture<HolderLookup.Provider> lookupProvider, DataGenerator generatorIn) {
        super(generatorIn);
        this.lookupProvider = lookupProvider;
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        this.collectJsons(pOutput);
        ArrayList futures = new ArrayList();
        return this.lookupProvider.thenCompose(registry -> {
            for (ImbuementRecipe g : this.recipes) {
                Path path = this.getRecipePath(this.output, g.id.getPath());
                futures.add(net.minecraft.data.DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)registry, (Codec)ImbuementRecipe.CODEC, (Object)g, (Path)path));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        });
    }

    public void collectJsons(CachedOutput pOutput) {
        this.recipes.add(new ImbuementRecipe("silver_transmute", Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}), new ItemStack((ItemLike)OccultismItems.SILVER_INGOT.get(), 1), 2000).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE).withPedestalItem((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM));
        this.recipes.add(new ImbuementRecipe("gold_transmute", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SILVER_INGOT.get()}), new ItemStack((ItemLike)Items.GOLD_INGOT, 1), 2000).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem((ItemLike)ItemsRegistry.MAGE_BLOOM).withPedestalItem((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM));
    }

    protected Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/" + DataProvider.root + "/recipe/" + str + ".json");
    }

    public String getName() {
        return "Ars Ocultas - Imbuement";
    }
}

