/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.spell;

import alexthw.not_enough_glyphs.init.ArsNouveauRegistry;
import alexthw.not_enough_glyphs.init.Registry;
import com.hollingsworth.arsnouveau.api.block.IPrismaticBlock;
import com.hollingsworth.arsnouveau.api.event.SpellProjectileHitEvent;
import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.ProjectileTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineMap;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public class MissileProjectile
extends EntityProjectileSpell {
    public float aoe;
    public boolean activateOnEmpty;
    int maxAge = 200;
    public Set<BlockPos> hitList = new HashSet<BlockPos>();

    public MissileProjectile(EntityType<? extends MissileProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public MissileProjectile(Level world, SpellResolver resolver) {
        this(world, resolver, 200, true, resolver.spell.getBuffsAtIndex(0, resolver.spellContext.getUnwrappedCaster(), (AbstractAugment)AugmentAOE.INSTANCE));
    }

    public MissileProjectile(Level world, SpellResolver resolver, int maxAge, boolean activate, float aoe) {
        super(Registry.MISSILE_PROJECTILE.get(), world, resolver);
        this.aoe = aoe;
        this.maxAge = maxAge;
        this.activateOnEmpty = activate;
    }

    public void tick() {
        super.tick();
        if (this.age > this.maxAge) {
            this.ExplodeMissile();
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void buildEmitters() {
        TimelineMap timelineMap = this.resolver().spell.particleTimeline();
        ProjectileTimeline projectileTimeline = (ProjectileTimeline)timelineMap.get((IParticleTimelineType)ArsNouveauRegistry.MISSILE_TIMELINE.get());
        TimelineEntryData trailConfig = projectileTimeline.trailEffect;
        TimelineEntryData resolveConfig = projectileTimeline.onResolvingEffect;
        TimelineEntryData spawnConfig = projectileTimeline.onSpawnEffect;
        TimelineEntryData flairConfig = projectileTimeline.flairEffect;
        this.tickEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((MissileProjectile)this).getRotationVector(), trailConfig);
        this.resolveEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((MissileProjectile)this).getRotationVector(), resolveConfig);
        this.onSpawnEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((MissileProjectile)this).getRotationVector(), spawnConfig);
        this.flairEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((MissileProjectile)this).getRotationVector(), flairConfig);
        this.castSound = projectileTimeline.castSound.sound;
        this.resolveSound = projectileTimeline.resolveSound.sound;
    }

    protected void onHit(HitResult result) {
        result = this.transformHitResult(result);
        if (!this.level().isClientSide) {
            SpellProjectileHitEvent event = new SpellProjectileHitEvent((EntityProjectileSpell)this, result);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            if (result instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)result;
                if (entityHitResult.getEntity().equals((Object)this.getOwner())) {
                    return;
                }
                if (this.resolver() != null) {
                    this.activateSpellAtPos(entityHitResult.getEntity().position());
                    this.sendResolveParticles();
                    this.attemptRemoval();
                }
            }
            if (result instanceof BlockHitResult) {
                BlockHitResult blockraytraceresult = (BlockHitResult)result;
                if (!this.isRemoved() && !this.hitList.contains(blockraytraceresult.getBlockPos())) {
                    BlockState state = this.level().getBlockState(blockraytraceresult.getBlockPos());
                    Block block = state.getBlock();
                    if (block instanceof IPrismaticBlock) {
                        IPrismaticBlock prismaticBlock = (IPrismaticBlock)block;
                        prismaticBlock.onHit((ServerLevel)this.level(), blockraytraceresult.getBlockPos(), (EntityProjectileSpell)this);
                        return;
                    }
                    if (state.is(BlockTags.PORTALS)) {
                        state.entityInside(this.level(), blockraytraceresult.getBlockPos(), (Entity)this);
                        return;
                    }
                    if (state.getBlock() instanceof TargetBlock) {
                        this.onHitBlock(blockraytraceresult);
                    }
                    if (this.resolver() != null) {
                        this.hitList.add(blockraytraceresult.getBlockPos());
                        this.activateSpellAtPos(blockraytraceresult.getLocation());
                    }
                    this.sendResolveParticles();
                    this.attemptRemoval();
                }
            }
        }
    }

    protected void activateSpellAtPos(Vec3 pos) {
        if (!this.level().isClientSide() && this.resolver() != null) {
            float sideOffset = 5.0f + 1.3f * this.aoe;
            float upOffset = 2.0f + this.aoe;
            Vec3 offset = new Vec3((double)sideOffset, (double)upOffset, (double)sideOffset);
            AABB axis = new AABB(pos.x + offset.x, pos.y + offset.y, pos.z + offset.z, pos.x - offset.x, pos.y - offset.y, pos.z - offset.z);
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, axis, entity -> entity != this.resolver().spellContext.getUnwrappedCaster());
            if (!entities.isEmpty()) {
                for (LivingEntity entity2 : entities) {
                    this.resolver().onResolveEffect(this.level(), (HitResult)new EntityHitResult((Entity)entity2));
                }
            } else if (this.activateOnEmpty) {
                Vec3 vector3d2 = this.position();
                Vec3 dist = this.getOwner() == null ? new Vec3(0.0, 1.0, 0.0) : this.position().subtract(this.getOwner().position());
                this.resolver().onResolveEffect(this.level(), (HitResult)new BlockHitResult(vector3d2, Direction.getNearest((double)dist.x, (double)dist.y, (double)dist.z), BlockPos.containing((Position)vector3d2), true));
            }
        }
    }

    protected void ExplodeMissile() {
        this.activateSpellAtPos(this.position());
        this.sendResolveParticles();
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("maxAge")) {
            this.maxAge = tag.getInt("maxAge");
        }
        if (tag.contains("aoe")) {
            this.aoe = tag.getFloat("aoe");
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("maxAge", this.maxAge);
        tag.putFloat("aoe", this.aoe);
    }

    @NotNull
    public EntityType<?> getType() {
        return Registry.MISSILE_PROJECTILE.get();
    }
}

