/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.command;

import com.cursee.monolib.core.CommonConfigValues;
import com.cursee.monolib.core.command.CommandHelper;
import com.cursee.monolib.core.command.hand.HandCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class MonoLibCommands {
    public static void defineCommands(CommandDispatcher<CommandSourceStack> commandDispatcher, CommandBuildContext commandContext, Commands.CommandSelection commandEnvironment) {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)"monolib");
        root.then(MonoLibCommands.questionMark());
        root.then(MonoLibCommands.help());
        root.then(MonoLibCommands.debug());
        root.then(MonoLibCommands.hand());
        commandDispatcher.register(root);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> questionMark() {
        LiteralArgumentBuilder command = Commands.literal((String)"?");
        command.executes(commandContext -> MonoLibCommands.showCommandHelp((CommandSourceStack)commandContext.getSource()));
        return command;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> help() {
        LiteralArgumentBuilder command = Commands.literal((String)"help");
        command.executes(commandContext -> MonoLibCommands.showCommandHelp((CommandSourceStack)commandContext.getSource()));
        return command;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> debug() {
        LiteralArgumentBuilder command = Commands.literal((String)"debug");
        command.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                return 1;
            }
            CommonConfigValues.enable_debugging = !CommonConfigValues.enable_debugging;
            player.sendSystemMessage((Component)Component.literal((String)("monolib enable_debugging: " + CommonConfigValues.enable_debugging)));
            return 1;
        });
        return command;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> hand() {
        return CommandHelper.buildFromEnum("hand", HandCommand.class);
    }

    public static int showCommandHelp(CommandSourceStack source) {
        if (MonoLibCommands.isPlayerOperator(source) && source.getPlayer() != null) {
            source.getPlayer().sendSystemMessage((Component)Component.literal((String)"/monolib debug"));
            source.getPlayer().sendSystemMessage((Component)Component.literal((String)" - Toggles MonoLib's debugging value. (Chat Spam Likely)"));
        }
        return 1;
    }

    public static boolean isPlayerOperator(CommandSourceStack source) {
        boolean isPlayer = source.isPlayer();
        ServerPlayer player = source.getPlayer();
        MinecraftServer server = source.getServer();
        return isPlayer && player != null && source.hasPermission(server.getOperatorUserPermissionLevel());
    }
}

