/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.command;

import com.cursee.monolib.core.command.IEnumCommand;
import com.cursee.monolib.core.command.PermissionLevel;
import com.cursee.monolib.mixin.AccessorCommandContext;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;

public class CommandHelper {
    public static <T extends Enum<T>> LiteralArgumentBuilder<CommandSourceStack> buildFromEnum(String parent, Class<T> enumClass) {
        LiteralArgumentBuilder parentNode = LiteralArgumentBuilder.literal((String)parent);
        parentNode.requires((Predicate)CommandHelper.getLowestLevel(enumClass));
        CommandHelper.buildFromEnum(parentNode, enumClass);
        return parentNode;
    }

    public static <T extends Enum<T>> void buildFromEnum(ArgumentBuilder<CommandSourceStack, ?> parent, Class<T> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalStateException("Class '" + enumClass.getCanonicalName() + "' is not an enum!");
        }
        for (Enum enumEntry : (Enum[])enumClass.getEnumConstants()) {
            LiteralArgumentBuilder literal = LiteralArgumentBuilder.literal((String)((IEnumCommand)((Object)enumEntry)).getCommandName());
            ((LiteralArgumentBuilder)literal.requires((Predicate)((IEnumCommand)((Object)enumEntry)).requiredPermissionLevel())).executes((Command)enumEntry);
            parent.then((ArgumentBuilder)literal);
        }
    }

    public static <T extends Enum<T>> PermissionLevel getLowestLevel(Class<T> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalStateException("Class '" + enumClass.getCanonicalName() + "' is not an enum!");
        }
        PermissionLevel level = PermissionLevel.OWNER;
        for (Enum enumEntry : (Enum[])enumClass.getEnumConstants()) {
            if (((IEnumCommand)((Object)enumEntry)).requiredPermissionLevel().get() >= level.get()) continue;
            level = ((IEnumCommand)((Object)enumEntry)).requiredPermissionLevel();
        }
        return level;
    }

    public static <T> boolean hasArgument(String argument, CommandContext<T> context) {
        AccessorCommandContext access;
        return context instanceof AccessorCommandContext && (access = (AccessorCommandContext)context).monolib$getArguments().containsKey(argument);
    }
}

