/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.DeltaFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;
import quek.undergarden.registry.UGBlocks;

public class UGDeltaFeature
extends DeltaFeature {
    private static final ImmutableList<Block> CANNOT_REPLACE = ImmutableList.of((Object)Blocks.BEDROCK, (Object)Blocks.CHEST, (Object)Blocks.SPAWNER, (Object)((Block)UGBlocks.SMOGSTEM_LEAVES.get()), (Object)((Block)UGBlocks.WIGGLEWOOD_LEAVES.get()), (Object)((Block)UGBlocks.GRONGLE_LEAVES.get()), (Object)((Block)UGBlocks.BLOOD_MUSHROOM_CAP.get()), (Object)((Block)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get()), (Object)((Block)UGBlocks.INDIGO_MUSHROOM_CAP.get()), (Object)((Block)UGBlocks.INK_MUSHROOM_CAP.get()), (Object)((Block)UGBlocks.VEIL_MUSHROOM_CAP.get()), (Object)((Block)UGBlocks.DEPTHROCK.get()), (Object[])new Block[]{(Block)UGBlocks.SHIVERSTONE.get(), (Block)UGBlocks.DREADROCK.get(), Blocks.PACKED_ICE, Blocks.SNOW_BLOCK});
    private static final Direction[] DIRECTIONS = Direction.values();

    public UGDeltaFeature(Codec<DeltaFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<DeltaFeatureConfiguration> context) {
        BlockPos blockpos1;
        boolean generate = false;
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        DeltaFeatureConfiguration config = (DeltaFeatureConfiguration)context.config();
        BlockPos pos = context.origin();
        boolean rimChance = random.nextDouble() < 0.9;
        int i = rimChance ? config.rimSize().sample(random) : 0;
        int j = rimChance ? config.rimSize().sample(random) : 0;
        boolean flag2 = rimChance && i != 0 && j != 0;
        int k = config.size().sample(random);
        int l = config.size().sample(random);
        int i1 = Math.max(k, l);
        Iterator iterator = BlockPos.withinManhattan((BlockPos)pos, (int)k, (int)0, (int)l).iterator();
        while (iterator.hasNext() && (blockpos1 = (BlockPos)iterator.next()).distManhattan((Vec3i)pos) <= i1) {
            BlockPos blockpos2;
            if (!UGDeltaFeature.isClear((LevelAccessor)level, blockpos1, config)) continue;
            if (flag2) {
                generate = true;
                this.setBlock((LevelWriter)level, blockpos1, config.rim());
            }
            if (!UGDeltaFeature.isClear((LevelAccessor)level, blockpos2 = blockpos1.offset(i, 0, j), config)) continue;
            generate = true;
            this.setBlock((LevelWriter)level, blockpos2, config.contents());
        }
        return generate;
    }

    private static boolean isClear(LevelAccessor level, BlockPos pos, DeltaFeatureConfiguration config) {
        BlockState state = level.getBlockState(pos);
        if (state.is(config.contents().getBlock()) || CANNOT_REPLACE.contains((Object)state.getBlock()) || !state.isSolidRender((BlockGetter)level, pos)) {
            return false;
        }
        for (Direction direction : DIRECTIONS) {
            boolean isAir = level.getBlockState(pos.relative(direction)).isAir();
            if ((!isAir || direction == Direction.UP) && (isAir || direction != Direction.UP)) continue;
            return false;
        }
        return true;
    }
}

