/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import quek.undergarden.entity.Boomgourd;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class UGDispenserBehaviors {
    public static void register() {
        DefaultDispenseItemBehavior bucketBehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource source, ItemStack stack) {
                BucketItem bucketitem = (BucketItem)stack.getItem();
                BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel world = source.level().getLevel();
                if (bucketitem.emptyContents(null, (Level)world, blockpos, null)) {
                    bucketitem.checkExtraContent(null, (Level)world, stack, blockpos);
                    return new ItemStack((ItemLike)Items.BUCKET);
                }
                return this.defaultBehavior.dispense(source, stack);
            }
        };
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UGItems.VIRULENT_MIX_BUCKET.get()), (DispenseItemBehavior)bucketBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UGItems.GWIBLING_BUCKET.get()), (DispenseItemBehavior)bucketBehavior);
        DispenserBlock.registerProjectileBehavior(UGItems.DEPTHROCK_PEBBLE);
        DispenserBlock.registerProjectileBehavior(UGItems.GOO_BALL);
        DispenserBlock.registerProjectileBehavior(UGItems.ROTTEN_BLISTERBERRY);
        DispenserBlock.registerProjectileBehavior(UGItems.BLISTERBOMB);
        DispenserBlock.registerProjectileBehavior(UGBlocks.GRONGLET);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UGBlocks.BOOMGOURD.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                ServerLevel level = source.level().getLevel();
                BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                Boomgourd gourd = new Boomgourd((Level)level, (double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5, null);
                level.addFreshEntity((Entity)gourd);
                level.playSound(null, gourd.getX(), gourd.getY(), gourd.getZ(), (SoundEvent)UGSoundEvents.BOOMGOURD_PRIMED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, blockpos);
                stack.shrink(1);
                return stack;
            }
        });
    }
}

