/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import java.util.List;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import quek.undergarden.registry.UGBiomes;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.world.gen.UGNoiseBasedChunkGenerator;

public class UGDimensions {
    public static final ResourceKey<Level> UNDERGARDEN_LEVEL = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)UGDimensions.name("undergarden"));
    public static final ResourceKey<NoiseGeneratorSettings> UNDERGARDEN_NOISE_GEN = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)UGDimensions.name("undergarden"));
    public static final ResourceKey<DimensionType> UNDERGARDEN_DIM_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)UGDimensions.name("undergarden"));
    public static final ResourceKey<LevelStem> UNDERGARDEN_LEVEL_STEM = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)UGDimensions.name("undergarden"));

    private static ResourceLocation name(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)name);
    }

    public static void bootstrapType(BootstrapContext<DimensionType> context) {
        context.register(UNDERGARDEN_DIM_TYPE, (Object)new DimensionType(OptionalLong.of(18000L), false, true, false, true, 4.0, true, false, -64, 192, 192, BlockTags.INFINIBURN_OVERWORLD, UGDimensions.name("undergarden"), 0.1f, new DimensionType.MonsterSettings(true, false, (IntProvider)UniformInt.of((int)0, (int)7), 0)));
    }

    public static void bootstrapStem(BootstrapContext<LevelStem> context) {
        HolderGetter biomeRegistry = context.lookup(Registries.BIOME);
        HolderGetter dimTypes = context.lookup(Registries.DIMENSION_TYPE);
        HolderGetter noiseGenSettings = context.lookup(Registries.NOISE_SETTINGS);
        context.register(UNDERGARDEN_LEVEL_STEM, (Object)new LevelStem((Holder)dimTypes.getOrThrow(UNDERGARDEN_DIM_TYPE), (ChunkGenerator)new UGNoiseBasedChunkGenerator(UGBiomes.buildBiomeSource((HolderGetter<Biome>)biomeRegistry), (Holder<NoiseGeneratorSettings>)noiseGenSettings.getOrThrow(UNDERGARDEN_NOISE_GEN))));
    }

    public static void bootstrapNoise(BootstrapContext<NoiseGeneratorSettings> context) {
        HolderGetter functions = context.lookup(Registries.DENSITY_FUNCTION);
        HolderGetter noises = context.lookup(Registries.NOISE);
        DensityFunction xShift = NoiseRouterData.getFunction((HolderGetter)functions, (ResourceKey)NoiseRouterData.SHIFT_X);
        DensityFunction zShift = NoiseRouterData.getFunction((HolderGetter)functions, (ResourceKey)NoiseRouterData.SHIFT_Z);
        context.register(UNDERGARDEN_NOISE_GEN, (Object)new NoiseGeneratorSettings(NoiseSettings.create((int)-64, (int)192, (int)2, (int)2), ((Block)UGBlocks.DEPTHROCK.get()).defaultBlockState(), Blocks.WATER.defaultBlockState(), new NoiseRouter(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.shiftedNoise2d((DensityFunction)xShift, (DensityFunction)zShift, (double)0.25, (Holder)noises.getOrThrow(Noises.TEMPERATURE)), DensityFunctions.shiftedNoise2d((DensityFunction)xShift, (DensityFunction)zShift, (double)0.25, (Holder)noises.getOrThrow(Noises.VEGETATION)), NoiseRouterData.getFunction((HolderGetter)functions, (ResourceKey)NoiseRouterData.CONTINENTS), NoiseRouterData.getFunction((HolderGetter)functions, (ResourceKey)NoiseRouterData.EROSION), DensityFunctions.rangeChoice((DensityFunction)NoiseRouterData.getFunction((HolderGetter)functions, (ResourceKey)NoiseRouterData.Y), (double)0.0, (double)32.0, (DensityFunction)DensityFunctions.constant((double)-1.0), (DensityFunction)DensityFunctions.rangeChoice((DensityFunction)NoiseRouterData.getFunction((HolderGetter)functions, (ResourceKey)NoiseRouterData.Y), (double)-64.0, (double)0.0, (DensityFunction)DensityFunctions.constant((double)-2.0), (DensityFunction)DensityFunctions.constant((double)0.0))), NoiseRouterData.getFunction((HolderGetter)functions, (ResourceKey)NoiseRouterData.RIDGES), DensityFunctions.zero(), DensityFunctions.mul((DensityFunction)DensityFunctions.interpolated((DensityFunction)DensityFunctions.blendDensity((DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)2.5), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.yClampedGradient((int)24, (int)-8, (double)0.0, (double)1.0), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-2.5), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)0.5), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.yClampedGradient((int)-40, (int)-64, (double)1.0, (double)0.0), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.5), (DensityFunction)BlendedNoise.createUnseeded((double)0.5, (double)0.5, (double)50.0, (double)50.0, (double)8.0))))))))), (DensityFunction)DensityFunctions.interpolated((DensityFunction)DensityFunctions.blendDensity((DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)2.5), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.yClampedGradient((int)-8, (int)24, (double)0.0, (double)1.0), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-2.5), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)0.5), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.yClampedGradient((int)110, (int)128, (double)1.0, (double)0.0), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.5), (DensityFunction)BlendedNoise.createUnseeded((double)0.1, (double)0.3, (double)80.0, (double)60.0, (double)1.0)))))))))).squeeze(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero()), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"minecraft:bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.BEDROCK.defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"minecraft:bedrock_roof", (VerticalAnchor)VerticalAnchor.belowTop((int)5), (VerticalAnchor)VerticalAnchor.top())), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.BEDROCK.defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.belowTop((int)5), (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.DEPTHROCK.get()).defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)0), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)33), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.SEDIMENT.get()).defaultBlockState())))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{UGBiomes.BLOOD_MUSHROOM_BOG}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)noises.getOrThrow(Noises.NETHER_STATE_SELECTOR).key(), (double)0.0, (double)1.8), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.COARSE_DEEPSOIL.get()).defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.DEEPTURF_BLOCK.get()).defaultBlockState()))}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{UGBiomes.SMOG_SPIRES}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)noises.getOrThrow(Noises.NETHER_STATE_SELECTOR).key(), (double)0.0, (double)1.8), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.COARSE_DEEPSOIL.get()).defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.ASHEN_DEEPTURF_BLOCK.get()).defaultBlockState()))}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{UGBiomes.BARREN_ABYSS, UGBiomes.DEAD_SEA}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)noises.getOrThrow(Noises.NETHER_STATE_SELECTOR).key(), (double)0.0, (double)1.8), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.COARSE_DEEPSOIL.get()).defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.DEPTHROCK.get()).defaultBlockState())), SurfaceRules.state((BlockState)((Block)UGBlocks.DEPTHROCK.get()).defaultBlockState())}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{UGBiomes.FROSTFIELDS, UGBiomes.ICY_SEA, UGBiomes.FROSTY_SMOGSTEM_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)noises.getOrThrow(Noises.POWDER_SNOW).key(), (double)0.45, (double)0.58), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.POWDER_SNOW.defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.FROZEN_DEEPTURF_BLOCK.get()).defaultBlockState()))}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{UGBiomes.DEPTHS, UGBiomes.INFECTED_DEPTHS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)noises.getOrThrow(Noises.POWDER_SNOW).key(), (double)0.45, (double)0.58), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.COARSE_DEEPSOIL.get()).defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.DREADROCK.get()).defaultBlockState())), SurfaceRules.state((BlockState)((Block)UGBlocks.DREADROCK.get()).defaultBlockState())}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{UGBiomes.ROGDORIUM_GROVE}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)noises.getOrThrow(Noises.NETHER_STATE_SELECTOR).key(), (double)0.0, (double)1.8), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.COARSE_DEEPSOIL.get()).defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.DEEPTURF_BLOCK.get()).defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.DEEPSOIL.get()).defaultBlockState()))}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{UGBiomes.PUFF_MUSHROOM_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.COARSE_DEEPSOIL.get()).defaultBlockState()))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)0), (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.DEEPTURF_BLOCK.get()).defaultBlockState()))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)0), (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.DEEPSOIL.get()).defaultBlockState()))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{UGBiomes.FROSTFIELDS, UGBiomes.ICY_SEA, UGBiomes.FROSTY_SMOGSTEM_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.SHIVERSTONE.get()).defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"undergarden:dreadrock", (VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)5)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)UGBlocks.DREADROCK.get()).defaultBlockState()))}), List.of(), 32, false, false, false, false));
    }
}

