/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.bucket;

import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.registries.datamaps.builtin.FurnaceFuel;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.item.bucket.BucketDispenseBehavior;
import quek.undergarden.registry.UGDataComponents;

public class UGBucketItem
extends Item {
    public UGBucketItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new BucketDispenseBehavior());
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        ItemStack copy = new ItemStack((ItemLike)this);
        copy.applyComponents(stack.getComponents());
        IFluidHandlerItem tank = (IFluidHandlerItem)copy.getCapability(Capabilities.FluidHandler.ITEM);
        if (tank != null) {
            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        }
        return copy;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        IFluidHandlerItem tank = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (tank != null) {
            return tank.getFluidInTank(0).getAmount() > 0;
        }
        return false;
    }

    public Component getName(ItemStack stack) {
        if (!((CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY)).isEmpty()) {
            return Component.translatable((String)(this.getDescriptionId() + ".entity"), (Object[])new Object[]{Component.translatable((String)UGBucketItem.getBucketedEntity(stack).map(EntityType::getDescriptionId).orElse("?"))});
        }
        if (!((SimpleFluidContent)stack.getOrDefault(UGDataComponents.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).isEmpty()) {
            return Component.translatable((String)(this.getDescriptionId() + ".block"), (Object[])new Object[]{Component.translatable((String)((SimpleFluidContent)stack.get(UGDataComponents.STORED_FLUID)).getFluidType().getDescriptionId())});
        }
        if (!((BlockState)stack.getOrDefault(UGDataComponents.STORED_BLOCK, (Object)Blocks.AIR.defaultBlockState())).isAir()) {
            return Component.translatable((String)(this.getDescriptionId() + ".block"), (Object[])new Object[]{Component.translatable((String)((BlockState)stack.get(UGDataComponents.STORED_BLOCK)).getBlock().getDescriptionId())});
        }
        return super.getName(stack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UGBucketItem.isMilkBucket(stack) ? UseAnim.DRINK : UseAnim.NONE;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return UGBucketItem.isMilkBucket(stack) ? 32 : 0;
    }

    public int getBurnTime(ItemStack stack, RecipeType<?> type) {
        FluidStack fluid = ((SimpleFluidContent)stack.getOrDefault(UGDataComponents.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).copy();
        if (fluid.isEmpty() && fluid.getAmount() >= 1000) {
            FurnaceFuel fuel = (FurnaceFuel)fluid.getFluid().getBucket().builtInRegistryHolder().getData(NeoForgeDataMaps.FURNACE_FUELS);
            return fuel == null ? 0 : fuel.burnTime();
        }
        return super.getBurnTime(stack, type);
    }

    /*
     * Unable to fully structure code
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        block14: {
            block15: {
                stack = player.getItemInHand(hand);
                isEmpty = UGBucketItem.isBucketEmpty(stack);
                blockHitResult = UGBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(isEmpty != false ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
                if (blockHitResult.getType() != HitResult.Type.BLOCK) break block14;
                hitBlockPos = blockHitResult.getBlockPos();
                hitBlockState = level.getBlockState(hitBlockPos);
                hitDirection = blockHitResult.getDirection();
                relativeBlockPos = hitBlockPos.relative(hitDirection);
                if (!isEmpty) break block15;
                pickup = this.tryPickupFluid(stack, level, player);
                if (pickup.getResult().consumesAction()) {
                    return pickup;
                }
                var13_15 = hitBlockState.getBlock();
                if (!(var13_15 instanceof BucketPickup)) break block14;
                bucketPickup = (BucketPickup)var13_15;
                if (hitBlockState.getBlock() instanceof LiquidBlock || (resultStack = bucketPickup.pickupBlock(player, (LevelAccessor)level, hitBlockPos, hitBlockState)).isEmpty()) break block14;
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                bucketPickup.getPickupSound(hitBlockState).ifPresent((Consumer<SoundEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$use$0(net.minecraft.world.entity.player.Player net.minecraft.sounds.SoundEvent ), (Lnet/minecraft/sounds/SoundEvent;)V)((Player)player));
                level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, hitBlockPos);
                workBucket = stack.copyWithCount(1);
                var16_21 = resultStack.getItem();
                if (!(var16_21 instanceof BucketItem)) ** GOTO lbl-1000
                bucket = (BucketItem)var16_21;
                if (bucket.content != Fluids.EMPTY) {
                    workBucket.set(UGDataComponents.STORED_FLUID, (Object)SimpleFluidContent.copyOf((FluidStack)new FluidStack(bucket.content, 1000)));
                } else lbl-1000:
                // 2 sources

                {
                    workBucket.set(UGDataComponents.STORED_BLOCK, (Object)hitBlockState);
                }
                if (!level.isClientSide()) {
                    CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, resultStack);
                }
                result = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)workBucket);
                player.setItemInHand(hand, result);
                return InteractionResultHolder.sidedSuccess((Object)result, (boolean)level.isClientSide());
            }
            if (UGBucketItem.hasFluid(stack)) {
                place = this.tryPlaceFluid(stack, level, player, hand);
                if (place.getResult().consumesAction()) {
                    if (UGBucketItem.getBucketedEntity((ItemStack)place.getObject()).isPresent()) {
                        emptyBucket = this.spawnEntityFromBucket(player, level, (ItemStack)place.getObject(), relativeBlockPos, player.hasInfiniteMaterials() == false);
                        ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)emptyBucket);
                        return InteractionResultHolder.sidedSuccess((Object)emptyBucket, (boolean)level.isClientSide());
                    }
                    return place;
                }
            } else {
                if (UGBucketItem.getBucketedEntity(stack).isPresent()) {
                    emptyBucket = this.spawnEntityFromBucket(player, level, stack, relativeBlockPos, player.hasInfiniteMaterials() == false);
                    if (!player.hasInfiniteMaterials()) {
                        player.setItemInHand(hand, emptyBucket);
                    }
                    return InteractionResultHolder.sidedSuccess((Object)emptyBucket, (boolean)level.isClientSide());
                }
                if (UGBucketItem.containsBlock(stack) && (block = (BlockState)stack.get(UGDataComponents.STORED_BLOCK)) != null) {
                    workBucket = stack.copy();
                    interactionResult = block.getBlock().asItem().useOn(new UseOnContext(player, hand, blockHitResult));
                    if (interactionResult.consumesAction()) {
                        if (!player.hasInfiniteMaterials()) {
                            workBucket.remove(UGDataComponents.STORED_BLOCK);
                        }
                        return InteractionResultHolder.sidedSuccess((Object)workBucket, (boolean)level.isClientSide());
                    }
                }
            }
        }
        if (UGBucketItem.isMilkBucket(stack)) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public ItemStack spawnEntityFromBucket(@Nullable Player player, Level level, ItemStack stack, BlockPos pos, boolean removeTag) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional<EntityType<?>> entityType = UGBucketItem.getBucketedEntity(stack);
            if (entityType.isPresent()) {
                Entity entity = entityType.get().spawn(serverLevel, stack, null, pos, MobSpawnType.BUCKET, true, false);
                if (entity instanceof Bucketable) {
                    Bucketable bucketable = (Bucketable)entity;
                    CustomData customdata = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
                    bucketable.loadFromBucketTag(customdata.copyTag());
                    bucketable.setFromBucket(true);
                }
                if (player != null) {
                    serverLevel.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
                }
                ItemStack workBucket = stack.copy();
                if (removeTag) {
                    workBucket.remove(DataComponents.BUCKET_ENTITY_DATA);
                }
                return workBucket;
            }
        }
        return stack.copy();
    }

    public int getMaxStackSize(ItemStack stack) {
        return UGBucketItem.isBucketEmpty(stack) ? 16 : 1;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        Goat goat;
        Cow cow;
        IFluidHandlerItem tank = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (entity instanceof Cow && !(cow = (Cow)entity).isBaby()) {
            if (tank != null && tank.fill(new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000), IFluidHandler.FluidAction.EXECUTE) > 0) {
                player.playSound(SoundEvents.COW_MILK);
                return InteractionResult.SUCCESS;
            }
        } else if (entity instanceof Goat && !(goat = (Goat)entity).isBaby()) {
            if (tank != null && tank.fill(new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000), IFluidHandler.FluidAction.EXECUTE) > 0) {
                player.playSound(goat.isScreamingGoat() ? SoundEvents.GOAT_SCREAMING_MILK : SoundEvents.GOAT_MILK);
                return InteractionResult.SUCCESS;
            }
        } else if (UGBucketItem.getBucketedEntity(stack).isEmpty() && entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            if (entity.isAlive()) {
                ItemStack workBucket = stack.copy();
                ItemStack bucketStack = bucketable.getBucketItemStack();
                Item item = bucketStack.getItem();
                if (item instanceof BucketItem) {
                    BucketItem bucket = (BucketItem)item;
                    Fluid containedFluid = bucket.content;
                    if (((SimpleFluidContent)stack.getOrDefault(UGDataComponents.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).is(containedFluid)) {
                        Level level;
                        entity.playSound(bucketable.getPickupSound());
                        bucketable.saveToBucketTag(workBucket);
                        String id = entity.getEncodeId();
                        if (id != null) {
                            CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)workBucket, tag -> tag.putString("id", id));
                        }
                        if (!(level = entity.level()).isClientSide()) {
                            CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, bucketStack);
                        }
                        player.setItemInHand(hand, workBucket);
                        entity.discard();
                        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        IFluidHandlerItem tank;
        ServerPlayer player;
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            CriteriaTriggers.CONSUME_ITEM.trigger(player, stack);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!level.isClientSide()) {
            entity.removeEffectsCuredBy(EffectCures.MILK);
        }
        if (entity instanceof Player && !(player = (Player)entity).hasInfiniteMaterials() && (tank = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)) != null) {
            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        }
        return stack;
    }

    private InteractionResultHolder<ItemStack> tryPlaceFluid(ItemStack stack, Level level, Player player, InteractionHand hand) {
        FluidActionResult result;
        BlockPos targetPos;
        if (((SimpleFluidContent)stack.getOrDefault(UGDataComponents.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).getAmount() < 1000) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockHitResult trace = UGBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (trace.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockPos pos = trace.getBlockPos();
        if (level.mayInteract(player, pos) && player.mayUseItemAt(targetPos = pos.relative(trace.getDirection()), trace.getDirection().getOpposite(), stack) && (result = FluidUtil.tryPlaceFluid((Player)player, (Level)level, (InteractionHand)hand, (BlockPos)targetPos, (ItemStack)stack, (FluidStack)((SimpleFluidContent)stack.getOrDefault(UGDataComponents.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).copy().copyWithAmount(1000))).isSuccess()) {
            ItemStack emptyStack = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)result.getResult());
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(sp, targetPos, stack);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)emptyStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private InteractionResultHolder<ItemStack> tryPickupFluid(ItemStack stack, Level level, Player player) {
        FluidActionResult result;
        Direction direction;
        if (!UGBucketItem.isBucketEmpty(stack)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockHitResult trace = UGBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (trace.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockPos pos = trace.getBlockPos();
        if (level.mayInteract(player, pos) && player.mayUseItemAt(pos, direction = trace.getDirection(), stack) && (result = FluidUtil.tryPickUpFluid((ItemStack)stack, (Player)player, (Level)level, (BlockPos)pos, (Direction)direction)).isSuccess()) {
            ItemStack filledStack = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)result.getResult());
            if (!level.isClientSide()) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, stack);
            }
            return InteractionResultHolder.success((Object)filledStack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private static boolean isMilkBucket(ItemStack stack) {
        return ((SimpleFluidContent)stack.getOrDefault(UGDataComponents.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).is((Fluid)NeoForgeMod.MILK.get());
    }

    public static boolean isBucketEmpty(ItemStack bucket) {
        return !UGBucketItem.hasFluid(bucket) && !UGBucketItem.containsBlock(bucket) && UGBucketItem.getBucketedEntity(bucket).isEmpty();
    }

    public static boolean hasFluid(ItemStack bucket) {
        return !((SimpleFluidContent)bucket.getOrDefault(UGDataComponents.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).isEmpty();
    }

    public static boolean containsBlock(ItemStack bucket) {
        return !((BlockState)bucket.getOrDefault(UGDataComponents.STORED_BLOCK, (Object)Blocks.AIR.defaultBlockState())).isAir();
    }

    public static Optional<EntityType<?>> getBucketedEntity(ItemStack bucket) {
        if (bucket.get(DataComponents.BUCKET_ENTITY_DATA) != null) {
            return EntityType.byString((String)((CustomData)bucket.get(DataComponents.BUCKET_ENTITY_DATA)).copyTag().getString("id"));
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$use$0(Player player, SoundEvent event) {
        player.playSound(event, 1.0f, 1.0f);
    }
}

