/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.monster.denizen;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import quek.undergarden.entity.monster.denizen.Denizen;
import quek.undergarden.registry.UGItems;

public class DenizenStareDownTargetGoal
extends NearestAttackableTargetGoal<Player> {
    public DenizenStareDownTargetGoal(Denizen denizen) {
        super((Mob)denizen, Player.class, true, entity -> !entity.getItemBySlot(EquipmentSlot.HEAD).is(UGItems.DENIZEN_MASK) || denizen.getTarget() == entity);
    }

    protected void findTarget() {
        Player nearestPlayer = this.mob.level().getNearestPlayer(this.targetConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
        if (nearestPlayer != null) {
            if ((double)this.mob.distanceTo((Entity)nearestPlayer) <= this.getFollowDistance() / 2.0 || this.mob.getTarget() == nearestPlayer) {
                this.target = nearestPlayer;
                ((Denizen)this.mob).setStareTarget(null);
            } else {
                ((Denizen)this.mob).setStareTarget((LivingEntity)nearestPlayer);
                this.mob.getNavigation().stop();
            }
        } else {
            ((Denizen)this.mob).setStareTarget(null);
            this.mob.setTarget(null);
        }
    }
}

