/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import quek.undergarden.entity.animal.Mog;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGTags;

public class SmogMog
extends Mog {
    public SmogMog(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.1).add(Attributes.KNOCKBACK_RESISTANCE, 0.9);
    }

    public static boolean checkSmogMogSpawnRules(EntityType<? extends Animal> entity, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(UGTags.Blocks.SMOG_MOG_SPAWNABLE_ON);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos.below()).is(UGTags.Blocks.SMOG_MOG_SPAWNABLE_ON) ? 10.0f : level.getPathfindingCostFromLightLevels(pos);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UGSoundEvents.SMOG_MOG_AMBIENT.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.SMOG_MOG_HURT.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.SMOG_MOG_DEATH.get();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)UGEntityTypes.SMOG_MOG.get()).create((Level)level);
    }

    public void aiStep() {
        if (this.level().isClientSide() && this.tickCount % 2 == 0) {
            double x = this.getX();
            double y = this.getY() + (double)this.getBbHeight();
            double z = this.getZ();
            if (this.isAlive()) {
                this.level().addAlwaysVisibleParticle((ParticleOptions)UGParticleTypes.SMOG.get(), x, y, z, 0.0, 0.05, 0.0);
            }
        }
        super.aiStep();
    }

    @Override
    public Item getMossItem() {
        return (Item)UGItems.BLUE_MOGMOSS.get();
    }
}

