/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class Mog
extends Animal
implements IShearable {
    private static final EntityDataAccessor<Boolean> HAS_MOSS = SynchedEntityData.defineId(Mog.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int timeWithoutMoss;

    public Mog(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGItems.DEPTHROCK_PEBBLE.get()}), false));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.1).add(Attributes.KNOCKBACK_RESISTANCE, 0.9).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UGSoundEvents.MOG_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.MOG_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.MOG_DEATH.get();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @javax.annotation.Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)UGEntityTypes.MOG.get()).create((Level)level);
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGItems.DEPTHROCK_PEBBLE.get()}).test(stack);
    }

    public void tick() {
        super.tick();
        this.timeWithoutMoss = !this.hasMoss() ? ++this.timeWithoutMoss : 0;
        if (this.timeWithoutMoss == 6000) {
            this.setMoss(true);
        }
    }

    public boolean hasMoss() {
        return (Boolean)this.getEntityData().get(HAS_MOSS);
    }

    public void setMoss(boolean hasMoss) {
        this.getEntityData().set(HAS_MOSS, (Object)hasMoss);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("HasMoss", this.hasMoss());
        this.timeWithoutMoss = tag.getInt("TimeWithoutMoss");
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setMoss(tag.getBoolean("HasMoss"));
        tag.putInt("TimeWithoutMoss", this.timeWithoutMoss);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_MOSS, (Object)true);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @javax.annotation.Nullable SpawnGroupData data) {
        this.setMoss(true);
        return super.finalizeSpawn(level, difficulty, spawnType, data);
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return this.hasMoss() && this.isAlive() && !this.isBaby();
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        level.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!level.isClientSide()) {
            this.setMoss(false);
            int mossAmount = 1 + this.getRandom().nextInt(2);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < mossAmount; ++i) {
                items.add(new ItemStack((ItemLike)this.getMossItem()));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public Item getMossItem() {
        return (Item)UGItems.MOGMOSS.get();
    }
}

