/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data.provider;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.SignBlock;
import net.neoforged.neoforge.common.Tags;
import quek.undergarden.data.builder.InfusingRecipeBuilder;
import quek.undergarden.data.builder.ItemInfusingRecipeBuilder;
import quek.undergarden.recipe.InfusingBookCategory;
import quek.undergarden.recipe.InfusingRecipe;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGItems;

public abstract class UGRecipeProvider
extends RecipeProvider {
    public UGRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
    }

    public ShapelessRecipeBuilder makePlanks(Supplier<? extends Block> plankOut, TagKey<Item> logIn) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)plankOut.get()), (int)4).requires(logIn).group("planks").unlockedBy("has_log", UGRecipeProvider.has(logIn));
    }

    public ShapelessRecipeBuilder makePlanks(Supplier<? extends Block> plankOut, Supplier<? extends Block> logIn) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)plankOut.get()), (int)4).requires((ItemLike)logIn.get()).group("planks").unlockedBy("has_log", UGRecipeProvider.has((ItemLike)((ItemLike)logIn.get())));
    }

    public ShapedRecipeBuilder makeDoor(Supplier<? extends Block> doorOut, Supplier<? extends Block> plankIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)doorOut.get()), (int)3).pattern("PP").pattern("PP").pattern("PP").define(Character.valueOf('P'), (ItemLike)plankIn.get()).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)plankIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)plankIn.get())));
    }

    public ShapedRecipeBuilder makeTrapdoor(Supplier<? extends Block> trapdoorOut, Supplier<? extends Block> plankIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)trapdoorOut.get()), (int)2).pattern("PPP").pattern("PPP").define(Character.valueOf('P'), (ItemLike)plankIn.get()).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)plankIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)plankIn.get())));
    }

    public ShapelessRecipeBuilder makeButton(Supplier<? extends Block> buttonOut, Supplier<? extends Block> blockIn) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)buttonOut.get())).requires((ItemLike)blockIn.get()).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makePressurePlate(Supplier<? extends Block> pressurePlateOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)pressurePlateOut.get())).pattern("BB").define(Character.valueOf('B'), (ItemLike)blockIn.get()).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeStairs(Supplier<? extends Block> stairsOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)stairsOut.get()), (int)4).pattern("M  ").pattern("MM ").pattern("MMM").define(Character.valueOf('M'), (ItemLike)blockIn.get()).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeSlab(Supplier<? extends Block> slabOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)slabOut.get()), (int)6).pattern("MMM").define(Character.valueOf('M'), (ItemLike)blockIn.get()).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeWall(Supplier<? extends Block> wallOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)wallOut.get()), (int)6).pattern("MMM").pattern("MMM").define(Character.valueOf('M'), (ItemLike)blockIn.get()).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeFence(Supplier<? extends Block> fenceOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)fenceOut.get()), (int)6).pattern("M/M").pattern("M/M").define(Character.valueOf('M'), (ItemLike)blockIn.get()).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeFenceGate(Supplier<? extends Block> fenceGateOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)fenceGateOut.get())).pattern("/M/").pattern("/M/").define(Character.valueOf('M'), (ItemLike)blockIn.get()).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeBricks(Supplier<? extends Block> bricksOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)bricksOut.get()), (int)4).pattern("MM").pattern("MM").define(Character.valueOf('M'), (ItemLike)blockIn.get()).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeChiseledBricks(Supplier<? extends Block> bricksOut, Supplier<? extends Block> blockIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)bricksOut.get())).pattern("M").pattern("M").define(Character.valueOf('M'), (ItemLike)blockIn.get()).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeWood(Supplier<? extends Block> woodOut, Supplier<? extends Block> logIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)woodOut.get()), (int)3).pattern("MM").pattern("MM").define(Character.valueOf('M'), (ItemLike)logIn.get()).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)logIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)logIn.get())));
    }

    public ShapedRecipeBuilder makeIngotToBlock(Supplier<? extends Block> blockOut, Supplier<? extends Item> ingotIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockOut.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ingotIn.get()).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)ingotIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)ingotIn.get())));
    }

    public ShapelessRecipeBuilder makeBlockToIngot(Supplier<? extends Item> ingotOut, Supplier<? extends Block> blockIn) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ingotOut.get()), (int)9).requires((ItemLike)blockIn.get()).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)blockIn.get())));
    }

    public ShapedRecipeBuilder makeNuggetToIngot(Supplier<? extends Item> ingotOut, Supplier<? extends Item> nuggetIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ingotOut.get()), (int)1).pattern("NNN").pattern("NNN").pattern("NNN").define(Character.valueOf('N'), (ItemLike)nuggetIn.get()).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)nuggetIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)nuggetIn.get())));
    }

    public ShapelessRecipeBuilder makeIngotToNugget(Supplier<? extends Item> nuggetOut, Supplier<? extends Item> ingotIn) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)nuggetOut.get()), (int)9).requires((ItemLike)ingotIn.get()).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)ingotIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)ingotIn.get())));
    }

    public ShapedRecipeBuilder makeSword(Supplier<? extends Item> swordOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)swordOut.get())).pattern("#").pattern("#").pattern("/").define(Character.valueOf('#'), (ItemLike)materialIn.get()).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)materialIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makePickaxe(Supplier<? extends Item> pickaxeOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)pickaxeOut.get())).pattern("###").pattern(" / ").pattern(" / ").define(Character.valueOf('#'), (ItemLike)materialIn.get()).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)materialIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeAxe(Supplier<? extends Item> axeOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)axeOut.get())).pattern("##").pattern("#/").pattern(" /").define(Character.valueOf('#'), (ItemLike)materialIn.get()).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)materialIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeShovel(Supplier<? extends Item> shovelOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)shovelOut.get())).pattern("#").pattern("/").pattern("/").define(Character.valueOf('#'), (ItemLike)materialIn.get()).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)materialIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeHoe(Supplier<? extends Item> hoeOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)hoeOut.get())).pattern("##").pattern(" /").pattern(" /").define(Character.valueOf('#'), (ItemLike)materialIn.get()).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)materialIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeHelmet(Supplier<? extends Item> helmetOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)helmetOut.get())).pattern("MMM").pattern("M M").define(Character.valueOf('M'), (ItemLike)materialIn.get()).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)materialIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeChestplate(Supplier<? extends Item> helmetOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)helmetOut.get())).pattern("M M").pattern("MMM").pattern("MMM").define(Character.valueOf('M'), (ItemLike)materialIn.get()).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)materialIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeLeggings(Supplier<? extends Item> helmetOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)helmetOut.get())).pattern("MMM").pattern("M M").pattern("M M").define(Character.valueOf('M'), (ItemLike)materialIn.get()).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)materialIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapedRecipeBuilder makeBoots(Supplier<? extends Item> helmetOut, Supplier<? extends Item> materialIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)helmetOut.get())).pattern("M M").pattern("M M").define(Character.valueOf('M'), (ItemLike)materialIn.get()).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)materialIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)materialIn.get())));
    }

    public ShapelessRecipeBuilder makeStew(Supplier<? extends Item> stewOut, Supplier<? extends Block> mushroomIn) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)stewOut.get())).requires((ItemLike)Items.BOWL).requires((ItemLike)mushroomIn.get(), 3).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)mushroomIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)mushroomIn.get())));
    }

    public ShapedRecipeBuilder makeBoat(Supplier<? extends Item> boatOut, Supplier<? extends Block> planksIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)boatOut.get())).pattern("P P").pattern("PPP").define(Character.valueOf('P'), (ItemLike)planksIn.get()).group("boat").unlockedBy("in_water", UGRecipeProvider.insideOf((Block)Blocks.WATER));
    }

    public ShapelessRecipeBuilder makeChestBoat(Supplier<? extends Item> chestBoatOut, Supplier<? extends Item> boatIn) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)chestBoatOut.get())).requires((ItemLike)boatIn.get()).requires(Tags.Items.CHESTS_WOODEN).group("chest_boat").unlockedBy("has_boat", UGRecipeProvider.has((TagKey)ItemTags.BOATS));
    }

    public ShapedRecipeBuilder makeSign(Supplier<? extends SignBlock> signOut, Supplier<? extends Block> planksIn) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)signOut.get()), (int)3).pattern("PPP").pattern("PPP").pattern(" / ").define(Character.valueOf('P'), (ItemLike)planksIn.get()).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)planksIn.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)planksIn.get())));
    }

    protected ShapedRecipeBuilder makeHangingSign(Supplier<? extends CeilingHangingSignBlock> result, Supplier<? extends Block> log) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)result.get()), (int)6).pattern("| |").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)log.get()).define(Character.valueOf('|'), (ItemLike)Items.CHAIN).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)log.get()).getPath(), UGRecipeProvider.has((ItemLike)((ItemLike)log.get())));
    }

    public void ore(ItemLike result, List<ItemLike> ingredients, float xp, String group, RecipeOutput consumer) {
        this.oreSmeltingRecipe(result, ingredients, xp, group, consumer);
        this.oreBlastingRecipe(result, ingredients, xp, group, consumer);
    }

    public SimpleCookingRecipeBuilder smeltingRecipe(ItemLike result, ItemLike ingredient, float exp) {
        return this.smeltingRecipe(result, ingredient, exp, 1);
    }

    private void oreSmeltingRecipe(ItemLike result, List<ItemLike> ingredients, float xp, String group, RecipeOutput consumer) {
        for (ItemLike ingredient : ingredients) {
            this.smeltingRecipe(result, ingredient, xp, 1).group(group).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)("smelt_" + BuiltInRegistries.ITEM.getKey((Object)ingredient.asItem()).getPath())));
        }
    }

    public SimpleCookingRecipeBuilder smeltingRecipe(ItemLike result, ItemLike ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack(ingredient, count)}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)exp, (int)200).unlockedBy("has_" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)ingredient.asItem())), UGRecipeProvider.has((ItemLike)ingredient));
    }

    public SimpleCookingRecipeBuilder smeltingRecipeTag(ItemLike result, TagKey<Item> ingredient, float exp) {
        return this.smeltingRecipeTag(result, ingredient, exp, 1);
    }

    public SimpleCookingRecipeBuilder smeltingRecipeTag(ItemLike result, TagKey<Item> ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(ingredient), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)exp, (int)200).unlockedBy("has_" + String.valueOf(ingredient), UGRecipeProvider.has(ingredient));
    }

    public SimpleCookingRecipeBuilder blastingRecipe(ItemLike result, ItemLike ingredient, float exp) {
        return this.blastingRecipe(result, ingredient, exp, 1);
    }

    private void oreBlastingRecipe(ItemLike result, List<ItemLike> ingredients, float xp, String group, RecipeOutput consumer) {
        for (ItemLike ingredient : ingredients) {
            this.blastingRecipe(result, ingredient, xp, 1).group(group).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)("blast_" + BuiltInRegistries.ITEM.getKey((Object)ingredient.asItem()).getPath())));
        }
    }

    public SimpleCookingRecipeBuilder blastingRecipe(ItemLike result, ItemLike ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack(ingredient, count)}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)exp, (int)100).unlockedBy("has_" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)ingredient.asItem())), UGRecipeProvider.has((ItemLike)ingredient));
    }

    public SimpleCookingRecipeBuilder blastingRecipeTag(ItemLike result, TagKey<Item> ingredient, float exp) {
        return this.blastingRecipeTag(result, ingredient, exp, 1);
    }

    public SimpleCookingRecipeBuilder blastingRecipeTag(ItemLike result, TagKey<Item> ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(ingredient), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)exp, (int)100).unlockedBy("has_" + String.valueOf(ingredient), UGRecipeProvider.has(ingredient));
    }

    public SimpleCookingRecipeBuilder smokingRecipe(ItemLike result, ItemLike ingredient, float exp) {
        return this.smokingRecipe(result, ingredient, exp, 1);
    }

    public SimpleCookingRecipeBuilder smokingRecipe(ItemLike result, ItemLike ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack(ingredient, count)}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)exp, (int)100).unlockedBy("has_" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)ingredient.asItem())), UGRecipeProvider.has((ItemLike)ingredient));
    }

    public SimpleCookingRecipeBuilder campfireRecipe(ItemLike result, ItemLike ingredient, float exp) {
        return this.campfireRecipe(result, ingredient, exp, 1);
    }

    public SimpleCookingRecipeBuilder campfireRecipe(ItemLike result, ItemLike ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack(ingredient, count)}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)exp, (int)600).unlockedBy("has_" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)ingredient.asItem())), UGRecipeProvider.has((ItemLike)ingredient));
    }

    public SmithingTransformRecipeBuilder smithingRecipe(Supplier<Item> input, Supplier<Item> upgradeItem, Supplier<Item> templateItem, Supplier<Item> result) {
        return SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)templateItem.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)input.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)upgradeItem.get()}), (RecipeCategory)RecipeCategory.MISC, (Item)result.get()).unlocks("has_" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)upgradeItem.get())), UGRecipeProvider.has((ItemLike)((ItemLike)upgradeItem.get())));
    }

    public SmithingTransformRecipeBuilder smithingForgotten(Supplier<Item> input, Supplier<Item> result) {
        return this.smithingRecipe(input, (Supplier<Item>)UGItems.FORGOTTEN_INGOT, (Supplier<Item>)UGItems.FORGOTTEN_UPGRADE_TEMPLATE, result);
    }

    public SingleItemRecipeBuilder stonecutting(Supplier<Block> input, ItemLike result) {
        return SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)input.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).unlockedBy("has_" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)input.get())), UGRecipeProvider.has((ItemLike)((ItemLike)input.get())));
    }

    public SingleItemRecipeBuilder stonecutting(Supplier<Block> input, ItemLike result, int resultAmount) {
        return SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)input.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)resultAmount).unlockedBy("has_" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)input.get())), UGRecipeProvider.has((ItemLike)((ItemLike)input.get())));
    }

    public SingleItemRecipeBuilder depthrockStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK, result);
    }

    public SingleItemRecipeBuilder depthrockStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK, result, resultAmount);
    }

    public SingleItemRecipeBuilder depthrockBricksStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK_BRICKS, result);
    }

    public SingleItemRecipeBuilder depthrockBricksStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK_BRICKS, result, resultAmount);
    }

    public SingleItemRecipeBuilder depthrockTilesStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK_TILES, result);
    }

    public SingleItemRecipeBuilder depthrockTilesStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DEPTHROCK_TILES, result, resultAmount);
    }

    public SingleItemRecipeBuilder polishedDepthrockStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.POLISHED_DEPTHROCK, result);
    }

    public SingleItemRecipeBuilder polishedDepthrockStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.POLISHED_DEPTHROCK, result, resultAmount);
    }

    public SingleItemRecipeBuilder shiverstoneStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.SHIVERSTONE, result);
    }

    public SingleItemRecipeBuilder shiverstoneStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.SHIVERSTONE, result, resultAmount);
    }

    public SingleItemRecipeBuilder shiverstoneBricksStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.SHIVERSTONE_BRICKS, result);
    }

    public SingleItemRecipeBuilder shiverstoneBricksStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.SHIVERSTONE_BRICKS, result, resultAmount);
    }

    public SingleItemRecipeBuilder tremblecrustStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.TREMBLECRUST, result);
    }

    public SingleItemRecipeBuilder tremblecrustStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.TREMBLECRUST, result, resultAmount);
    }

    public SingleItemRecipeBuilder tremblecrustBricksStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.TREMBLECRUST_BRICKS, result);
    }

    public SingleItemRecipeBuilder tremblecrustBricksStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.TREMBLECRUST_BRICKS, result, resultAmount);
    }

    public SingleItemRecipeBuilder dreadrockStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DREADROCK, result);
    }

    public SingleItemRecipeBuilder dreadrockStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DREADROCK, result, resultAmount);
    }

    public SingleItemRecipeBuilder dreadrockBricksStonecutting(ItemLike result) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DREADROCK_BRICKS, result);
    }

    public SingleItemRecipeBuilder dreadrockBricksStonecutting(ItemLike result, int resultAmount) {
        return this.stonecutting((Supplier<Block>)UGBlocks.DREADROCK_BRICKS, result, resultAmount);
    }

    public ItemInfusingRecipeBuilder itemInfusing(Ingredient ingredient, InfusingBookCategory bookCategory, float experience, int infusingTime) {
        return ItemInfusingRecipeBuilder.infusing(ingredient, bookCategory, experience, infusingTime);
    }

    public InfusingRecipeBuilder infusing(ItemLike result, ItemLike ingredient, InfusingBookCategory bookCategory, InfusingRecipe.SlotType type, float experience, int infusingTime) {
        return InfusingRecipeBuilder.infusing(Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), bookCategory, new ItemStack(result), experience, infusingTime, type).unlockedBy("has_item", UGRecipeProvider.has((ItemLike)ingredient));
    }

    public InfusingRecipeBuilder infusingPurifying(ItemLike result, ItemLike ingredient, float experience, int infusingTime) {
        return this.infusing(result, ingredient, InfusingBookCategory.PURIFYING, InfusingRecipe.SlotType.ROGDORIUM, experience, infusingTime);
    }

    public InfusingRecipeBuilder infusingCorrupting(ItemLike result, ItemLike ingredient, float experience, int infusingTime) {
        return this.infusing(result, ingredient, InfusingBookCategory.CORRUPTING, InfusingRecipe.SlotType.UTHERIUM, experience, infusingTime);
    }
}

