/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.compat.jei.category;

import java.util.Arrays;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import quek.undergarden.component.RogdoriumInfusion;
import quek.undergarden.recipe.InfuserConversionRecipe;
import quek.undergarden.recipe.InfusingRecipe;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDataComponents;

public class InfusingJEIRecipeCategory
implements IRecipeCategory<InfusingRecipe> {
    private static final ResourceLocation INFUSER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"textures/gui/container/infuser/infuser.png");
    public static final RecipeType<InfusingRecipe> RECIPE_TYPE = RecipeType.create((String)"undergarden", (String)"infusing", InfuserConversionRecipe.class);
    private final IDrawable icon;
    private final Component localizedName;

    public InfusingJEIRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack(UGBlocks.INFUSER));
        this.localizedName = Component.translatable((String)"gui.undergarden.jei.category.infuser");
    }

    public RecipeType<InfusingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public int getWidth() {
        return 126;
    }

    public int getHeight() {
        return 57;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InfusingRecipe recipe, IFocusGroup focuses) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.registryAccess();
        NonNullList recipeIngredients = recipe.getIngredients();
        builder.addSlot(RecipeIngredientRole.INPUT, 55, 1).addIngredients((Ingredient)recipeIngredients.getFirst());
        InfusingRecipe.SlotType slot = recipe.getRecipeSlotType();
        builder.addSlot(RecipeIngredientRole.INPUT, (slot.getSlotIndex() - 1) * 108 + 1, 37).addIngredients(Ingredient.of(slot.getValidItems()));
        if (recipe.getResultItem((HolderLookup.Provider)registryAccess).isEmpty()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 36).addItemStacks(Arrays.stream(((Ingredient)recipeIngredients.getFirst()).getItems()).map(stack -> {
                ItemStack copy = stack.copy();
                copy.set(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.setInfusionAmount(56));
                return copy;
            }).toList());
        } else {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 36).addItemStack(recipe.getResultItem((HolderLookup.Provider)registryAccess));
        }
    }

    public void draw(InfusingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(INFUSER_TEXTURE, 0, 0, 25, 16, this.getWidth(), this.getHeight());
        this.drawExperience(recipe, guiGraphics);
        this.drawCookTime(recipe, guiGraphics);
    }

    protected void drawExperience(InfusingRecipe recipe, GuiGraphics guiGraphics) {
        float experience = recipe.experience();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.translatable((String)"gui.undergarden.jei.category.infusing.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.getInstance();
            Font fontRenderer = minecraft.font;
            int stringWidth = fontRenderer.width((FormattedText)experienceString);
            guiGraphics.drawString(fontRenderer, (Component)experienceString, this.getWidth() - stringWidth, -1, -8355712, false);
        }
    }

    protected void drawCookTime(InfusingRecipe recipe, GuiGraphics guiGraphics) {
        int infusingTime = recipe.infusingTime();
        if (infusingTime > 0) {
            int infusingTimeSeconds = infusingTime / 20;
            MutableComponent timeString = Component.translatable((String)"gui.undergarden.jei.category.infusing.time.seconds", (Object[])new Object[]{infusingTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font fontRenderer = minecraft.font;
            int stringWidth = fontRenderer.width((FormattedText)timeString);
            guiGraphics.drawString(fontRenderer, (Component)timeString, this.getWidth() - stringWidth - 20, 45, -8355712, false);
        }
    }
}

