/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.particle;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.SimpleParticleType;
import quek.undergarden.registry.UGParticleTypes;

public class ShimmerParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    private ShimmerParticle(ClientLevel level, SpriteSet sprites, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprites = sprites;
        this.lifetime = 50;
        this.gravity = 0.01f;
        this.xd *= xSpeed;
        this.yd *= ySpeed;
        this.zd *= zSpeed;
        this.setSpriteFromAge(sprites);
        this.hasPhysics = true;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ShimmerParticle(this, level, this.sprites, x, y, z, xSpeed, ySpeed, zSpeed){

                public Optional<ParticleGroup> getParticleGroup() {
                    return Optional.of(UGParticleTypes.SHIMMER_GROUP);
                }
            };
        }
    }
}

