/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.gui.screen.inventory.recipebook;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import quek.undergarden.recipe.InfusingRecipe;

public class InfuserRecipeBookComponent
extends RecipeBookComponent {
    private static final WidgetSprites FILTER_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_filter_enabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_filter_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_filter_enabled_highlighted"), ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_filter_disabled_highlighted"));
    private static final Component FILTER_NAME = Component.translatable((String)"gui.undergarden.recipebook.toggleRecipes.infusable");

    protected void initFilterButtonTextures() {
        this.filterButton.initTextureValues(FILTER_SPRITES);
    }

    public void slotClicked(@Nullable Slot slot) {
        super.slotClicked(slot);
        if (slot != null && slot.index < this.menu.getSize()) {
            this.ghostRecipe.clear();
        }
    }

    public void setupGhostRecipe(RecipeHolder<?> recipe, List<Slot> slots) {
        ItemStack itemstack = recipe.value().getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess());
        this.ghostRecipe.setRecipe(recipe);
        this.ghostRecipe.addIngredient(Ingredient.of((ItemStack[])new ItemStack[]{itemstack}), slots.get((int)3).x, slots.get((int)3).y);
        NonNullList ingredients = recipe.value().getIngredients();
        InfusingRecipe infusingRecipe = (InfusingRecipe)recipe.value();
        Slot slot = slots.get(infusingRecipe.getRecipeSlotType().getSlotIndex());
        if (slot.getItem().isEmpty()) {
            this.ghostRecipe.addIngredient(Ingredient.of(infusingRecipe.getRecipeSlotType().getValidItems()), slot.x, slot.y);
        }
        Iterator iterator = ingredients.iterator();
        for (int i = 0; i < 3; ++i) {
            if (!iterator.hasNext()) {
                return;
            }
            Ingredient ingredient = (Ingredient)iterator.next();
            if (ingredient.isEmpty()) continue;
            Slot slot1 = slots.get(i);
            this.ghostRecipe.addIngredient(ingredient, slot1.x, slot1.y);
        }
    }

    protected Component getRecipeFilterName() {
        return FILTER_NAME;
    }
}

