/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.blocks.HyperEntranceBlock;
import com.pedrorok.hypertube.blocks.blockentities.TubeBlockEntity;
import com.pedrorok.hypertube.config.ServerConfig;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeActionPoint;
import com.pedrorok.hypertube.core.smarttube.ITubeAttachment;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.pedrorok.hypertube.core.travel.TravelPathMover;
import com.pedrorok.hypertube.registry.ModParticles;
import com.pedrorok.hypertube.registry.ModSounds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class ActionTubeBlockEntity
extends TubeBlockEntity {
    private static final float RADIUS = 1.0f;
    protected final UUID tubeSoundId = UUID.randomUUID();
    private final Map<Direction, ITubeAttachment> smartTubeAttachments = new HashMap<Direction, ITubeAttachment>();

    public ActionTubeBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        if (this.smartTubeAttachments.isEmpty()) {
            return;
        }
        CompoundTag smartTubesTag = new CompoundTag();
        for (Map.Entry<Direction, ITubeAttachment> entry : this.smartTubeAttachments.entrySet()) {
            smartTubesTag.put(entry.getKey().getSerializedName(), (Tag)Codec.STRING.write((DynamicOps)NbtOps.INSTANCE, (Object)entry.getValue().getId()));
        }
        compound.put("attachments", (Tag)smartTubesTag);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.smartTubeAttachments.clear();
        if (!compound.contains("attachments", 10)) {
            return;
        }
        CompoundTag smartTubesTag = compound.getCompound("attachments");
        for (Direction direction : Direction.values()) {
            String directionKey = direction.getSerializedName();
            if (!smartTubesTag.contains(directionKey, 8)) continue;
            String smartTubeId = smartTubesTag.getString(directionKey);
            ITubeAttachment smartTube = ITubeAttachment.get(smartTubeId);
            if (smartTube == null) {
                HypertubeMod.LOGGER.error("Failed to load smart tube attachment with id: {} for direction: {}", (Object)smartTubeId, (Object)direction);
                continue;
            }
            this.smartTubeAttachments.put(direction, smartTube);
        }
    }

    public void addTubeAttachment(Direction direction, ITubeAttachment smartTube) {
        this.smartTubeAttachments.put(direction, smartTube);
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void activateAllTubeAttachments(LivingEntity entity, TravelPathMover travelPathMover, BlockPos pos) {
        for (Map.Entry<Direction, ITubeAttachment> attachmentEntry : this.smartTubeAttachments.entrySet()) {
            ITubeAttachment value = attachmentEntry.getValue();
            ITubeActionPoint actionPoint = value.getActionPoint(attachmentEntry.getKey());
            if (actionPoint == null) continue;
            actionPoint.handleTravelPath(entity, travelPathMover, pos);
        }
    }

    public ITubeAttachment removeTubeAttachment(Direction direction) {
        ITubeAttachment removedAttachment = this.smartTubeAttachments.remove(direction);
        if (removedAttachment != null) {
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
                this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
            }
        }
        return removedAttachment;
    }

    @Nullable
    public ITubeAttachment getTubeAttachment(Direction direction) {
        return this.smartTubeAttachments.get(direction);
    }

    public boolean hasTubeAttachment(Direction direction) {
        return this.smartTubeAttachments.containsKey(direction);
    }

    public boolean hasAnyTubeAttachment() {
        return !this.smartTubeAttachments.isEmpty();
    }

    public Map<Direction, ITubeAttachment> getTubeAttachments() {
        return this.smartTubeAttachments;
    }

    public List<Direction> getAttachmentDirectionsNoEmit() {
        return this.smartTubeAttachments.entrySet().stream().filter(attach -> !((ITubeAttachment)attach.getValue()).emitRedstoneSignal()).map(Map.Entry::getKey).toList();
    }

    public Set<Direction> getAttachmentDirections() {
        return this.smartTubeAttachments.keySet();
    }

    public boolean canEmitTo(Direction direction) {
        ITubeAttachment attachment = this.smartTubeAttachments.get(direction);
        if (attachment == null) {
            return false;
        }
        return attachment.emitRedstoneSignal();
    }

    protected void spawnSuctionParticle(Level level, BlockPos blockPos, Direction face) {
        face = face.getOpposite();
        Vec3 center = Vec3.atCenterOf((Vec3i)blockPos);
        RandomSource rand = level.getRandom();
        Vec3 faceNormal = Vec3.atLowerCornerOf((Vec3i)face.getNormal());
        double spread = 0.5;
        Vec3 tangentA = switch (face.getAxis()) {
            case Direction.Axis.Y, Direction.Axis.Z -> new Vec3(1.0, 0.0, 0.0);
            default -> new Vec3(0.0, 1.0, 0.0);
        };
        Vec3 tangentB = faceNormal.cross(tangentA).normalize();
        double offsetA = (rand.nextDouble() - 0.5) * 2.0 * spread;
        double offsetB = (rand.nextDouble() - 0.5) * 2.0 * spread;
        Vec3 randomOffset = tangentA.scale(offsetA).add(tangentB.scale(offsetB));
        Vec3 start = center.add(faceNormal.scale((double)(1.0f + level.random.nextFloat()))).add(randomOffset);
        Vec3 motion = center.subtract(start).normalize().scale(0.05);
        level.addParticle((ParticleOptions)ModParticles.SUCTION_PARTICLE.get(), start.x, start.y, start.z, motion.x, motion.y, motion.z);
    }

    protected void playOpenCloseSound(boolean open) {
        RandomSource random = this.level.random;
        float pitch = 0.4f + random.nextFloat() * 0.4f;
        this.level.playSound(null, this.getBlockPos(), open ? (SoundEvent)ModSounds.HYPERTUBE_ENTRANCE_OPEN.get() : (SoundEvent)ModSounds.HYPERTUBE_ENTRANCE_CLOSE.get(), SoundSource.BLOCKS, 0.2f, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void playClientEffects(TubeSoundManager.TubeAmbientSound sound) {
        BlockState state = this.getBlockState();
        BlockPos pos = this.getBlockPos();
        boolean isOpen = (Boolean)state.getValue((Property)HyperEntranceBlock.OPEN);
        LocalPlayer player = Minecraft.getInstance().player;
        Vec3 source = pos.getCenter();
        Vec3 listener = player.position();
        Vec3 worldDirection = source.subtract(listener).normalize();
        Vec3 forward = player.getLookAngle().normalize();
        Vec3 up = player.getUpVector(1.0f).normalize();
        Vec3 right = forward.cross(up).normalize();
        double x = worldDirection.dot(right);
        double y = worldDirection.dot(up);
        double z = worldDirection.dot(forward);
        Vec3 rotatedDirection = new Vec3(x, y, z).normalize();
        double distance = player.distanceToSqr(source);
        if (isOpen) {
            this.spawnSuctionParticle(this.level, pos, (Direction)state.getValue((Property)HyperEntranceBlock.FACING));
        }
        sound.enableClientPlayerSound((Entity)player, rotatedDirection, distance, isOpen);
    }

    @Nullable
    protected LivingEntity getInRangeLivingEntities(ServerLevel level, Vec3 centerPos, Direction facing) {
        Vec3 checkPos = centerPos.add(Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()));
        return level.getNearestEntity(level.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)checkPos, (double)1.5, (double)1.5, (double)1.5), entity -> ServerConfig.canEntityTravel(entity.getType())), TargetingConditions.forNonCombat().ignoreLineOfSight(), null, centerPos.x, centerPos.y, centerPos.z);
    }

    @Nullable
    protected LivingEntity getNearbyLivingEntities(ServerLevel level, Vec3 centerPos) {
        return level.getNearestEntity(level.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)centerPos, (double)6.0, (double)6.0, (double)6.0), entity -> ServerConfig.canEntityTravel(entity.getType())), TargetingConditions.forNonCombat().ignoreLineOfSight(), null, centerPos.x, centerPos.y, centerPos.z);
    }

    protected boolean isTubeClosed(boolean canOpen, boolean isOpen) {
        BlockState state = this.getBlockState();
        BlockPos pos = this.getBlockPos();
        if (!canOpen) {
            if (isOpen) {
                this.level.setBlock(pos, (BlockState)state.setValue((Property)HyperEntranceBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
                this.playOpenCloseSound(false);
            }
            return true;
        }
        if (!isOpen) {
            this.level.setBlock(pos, (BlockState)state.setValue((Property)HyperEntranceBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
            this.playOpenCloseSound(true);
        }
        return false;
    }

    public void remove() {
        if (this.level.isClientSide) {
            this.removeClient();
        }
        super.remove();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void removeClient() {
        TubeSoundManager.getAmbientSound(this.tubeSoundId).stopSound();
        TubeSoundManager.removeAmbientSound(this.tubeSoundId);
    }
}

