/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks;

import com.pedrorok.hypertube.blocks.TubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.core.smarttube.ITubeAttachment;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class ActionTubeBlock
extends TubeBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public ActionTubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected abstract BooleanProperty propertyToUpdate();

    protected boolean isSignalSource(@NotNull BlockState state) {
        return super.isSignalSource(state);
    }

    protected int getDirectSignal(@NotNull BlockState blockState, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        return this.getSignal(blockState, blockAccess, pos, side);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        int currentPower = (Integer)state.getValue((Property)POWER);
        if (currentPower > 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(0)), 3);
            level.updateNeighborsAt(pos, (Block)this);
        }
    }

    protected int getSignal(@NotNull BlockState blockState, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        BlockEntity blockEntity = blockAccess.getBlockEntity(pos);
        if (!(blockEntity instanceof ActionTubeBlockEntity)) {
            return 0;
        }
        ActionTubeBlockEntity action = (ActionTubeBlockEntity)blockEntity;
        if (!action.hasTubeAttachment(side.getOpposite()) || !action.canEmitTo(side.getOpposite())) {
            return 0;
        }
        return (Integer)blockState.getValue((Property)POWER);
    }

    protected boolean getSignalSide(Level level, BlockPos pos, List<Direction> checkSides) {
        for (Direction direction : checkSides) {
            if (level.getSignal(pos.relative(direction), direction) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSignalOnSide(Level level, BlockPos pos, Direction side) {
        return level.getSignal(pos.relative(side), side) > 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        ActionTubeBlockEntity tubeBlockEntity = (ActionTubeBlockEntity)world.getBlockEntity(pos);
        if (tubeBlockEntity == null) {
            return false;
        }
        return side != null && side != state.getValue((Property)FACING) && side != ((Direction)state.getValue((Property)FACING)).getOpposite() && tubeBlockEntity.getAttachmentDirections().contains(side.getOpposite());
    }

    public static boolean canPlaceAttachment(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null && side != state.getValue((Property)FACING) && side != ((Direction)state.getValue((Property)FACING)).getOpposite();
    }

    protected void neighborChanged(BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        ActionTubeBlockEntity tubeBlockEntity = (ActionTubeBlockEntity)level.getBlockEntity(pos);
        if (tubeBlockEntity == null) {
            return;
        }
        boolean neighborHasSignal = this.getSignalSide(level, pos, tubeBlockEntity.getAttachmentDirectionsNoEmit());
        boolean actualState = (Boolean)state.getValue((Property)POWERED);
        if (neighborHasSignal && !actualState) {
            level.scheduleTick(pos, (Block)this, 4);
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true))).setValue((Property)this.propertyToUpdate(), (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)this.propertyToUpdate()) == false)), 2);
            IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
        } else if (!neighborHasSignal && actualState) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)this.propertyToUpdate(), (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)this.propertyToUpdate()) == false)), 2);
            IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
        }
    }

    @Override
    void dropBlockToPlayer(boolean isWrenched, Level level, BlockPos pos, Player player, BlockEntity blockEntity, int amount) {
        super.dropBlockToPlayer(isWrenched, level, pos, player, blockEntity, amount);
        if (player.isCreative()) {
            return;
        }
        if (!(blockEntity instanceof ActionTubeBlockEntity)) {
            return;
        }
        ActionTubeBlockEntity actionTubeBlock = (ActionTubeBlockEntity)blockEntity;
        actionTubeBlock.getTubeAttachments().forEach((dir, attachment) -> {
            ItemStack stack = attachment.getItemStack();
            if (isWrenched) {
                player.getInventory().placeItemBackInInventory(stack);
            } else {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            }
        });
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos clickedPos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(clickedPos);
        if (!(blockEntity instanceof ActionTubeBlockEntity)) {
            return InteractionResult.PASS;
        }
        ActionTubeBlockEntity action = (ActionTubeBlockEntity)blockEntity;
        if (!action.hasTubeAttachment(clickedFace)) {
            return InteractionResult.PASS;
        }
        ITubeAttachment iTubeAttachment = action.removeTubeAttachment(clickedFace);
        if (iTubeAttachment == null) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        if (!player.isCreative()) {
            ItemStack stack = iTubeAttachment.getItemStack();
            player.getInventory().placeItemBackInInventory(stack);
        }
        IWrenchable.playRemoveSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
        return InteractionResult.SUCCESS;
    }
}

