/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.client.gui.widgets;

import appeng.client.gui.Icon;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ITooltip;
import java.util.Collections;
import java.util.List;
import lu.kolja.expandedae.client.gui.widgets.ExpIcon;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ModifyIconButton
extends Button
implements ITooltip {
    private final ExpIcon icon;
    private final Component displayName;
    private final Component displayValue;
    private boolean halfSize = false;
    private boolean disableClickSound = false;
    private boolean disableBackground = false;

    public ModifyIconButton(Button.OnPress onPress, ExpIcon icon, Component displayName, Component displayValue) {
        super(0, 0, 8, 8, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.icon = icon;
        this.displayName = displayName;
        this.displayValue = displayValue;
    }

    public void setVisibility(boolean vis) {
        this.visible = vis;
        this.active = vis;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.visible) {
            int yOffset;
            Item item = this.getItemOverlay();
            if (this.halfSize) {
                this.width = 8;
                this.height = 8;
            }
            int n = yOffset = this.isHovered() ? 1 : 0;
            if (this.halfSize) {
                if (!this.disableBackground) {
                    Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(this.getX(), this.getY()).zOffset(10).blit(guiGraphics);
                }
                if (item != null) {
                    guiGraphics.renderItem(new ItemStack((ItemLike)item), this.getX(), this.getY(), 0, 20);
                } else if (this.icon != null) {
                    Blitter blitter = this.icon.getBlitter();
                    if (!this.active) {
                        blitter.opacity(0.5f);
                    }
                    blitter.dest(this.getX(), this.getY()).zOffset(20).blit(guiGraphics);
                }
            } else {
                if (!this.disableBackground) {
                    ExpIcon bgIcon = this.isHovered() ? ExpIcon.HALF_TOOLBAR_BUTTON_BACKGROUND_HOVER : (this.isFocused() ? ExpIcon.HALF_TOOLBAR_BUTTON_BACKGROUND_FOCUS : ExpIcon.HALF_TOOLBAR_BUTTON_BACKGROUND);
                    bgIcon.getBlitter().dest(this.getX() - 1, this.getY() + yOffset, 9, 10).zOffset(2).blit(guiGraphics);
                }
                if (item != null) {
                    guiGraphics.renderItem(new ItemStack((ItemLike)item), this.getX(), this.getY() + 1 + yOffset, 0, 3);
                } else if (this.icon != null) {
                    this.icon.getBlitter().dest(this.getX(), this.getY() + 1 + yOffset).zOffset(3).blit(guiGraphics);
                }
            }
        }
    }

    @Nullable
    protected Item getItemOverlay() {
        return null;
    }

    public List<Component> getTooltipMessage() {
        return Collections.singletonList(Component.empty().append(this.displayName).append("\n").append(this.displayValue));
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.getX(), this.getY(), 8, 8);
    }

    public boolean isTooltipAreaVisible() {
        return this.visible;
    }

    public boolean isHalfSize() {
        return this.halfSize;
    }

    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }

    public boolean isDisableClickSound() {
        return this.disableClickSound;
    }

    public void setDisableClickSound(boolean disableClickSound) {
        this.disableClickSound = disableClickSound;
    }

    public boolean isDisableBackground() {
        return this.disableBackground;
    }

    public void setDisableBackground(boolean disableBackground) {
        this.disableBackground = disableBackground;
    }
}

