/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.client.gui.widgets;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import lu.kolja.expandedae.client.gui.widgets.ExpActionItems;
import lu.kolja.expandedae.client.gui.widgets.ExpIcon;
import lu.kolja.expandedae.client.gui.widgets.ExpIconButton;
import lu.kolja.expandedae.definition.ExpText;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ExpActionButton
extends ExpIconButton {
    private static final Pattern PATTERN_NEW_LINE = Pattern.compile("\\n", 16);
    private final ExpIcon icon;

    public ExpActionButton(ExpActionItems action, Runnable onPress, int width, int height) {
        this(action, width, height, a -> onPress.run());
    }

    public ExpActionButton(ExpActionItems action, int width, int height, Consumer<ExpActionItems> onPress) {
        super(btn -> onPress.accept(action), width, height);
        ExpText displayName;
        this.setMessage(this.buildMessage(displayName, switch (action) {
            case ExpActionItems.MODIFY_PATTERNS -> {
                this.icon = ExpIcon.MODIFY_PATTERNS;
                displayName = ExpText.modifyPatterns;
                yield ExpText.modifyPatternsHint;
            }
            case ExpActionItems.ADVANCED_PATTERN_MODE -> {
                this.icon = ExpIcon.DOUBLE_ARROW;
                displayName = ExpText.arrow;
                yield ExpText.arrowHint;
            }
            default -> throw new IllegalArgumentException("Unknown ActionItem: " + String.valueOf((Object)action));
        }));
    }

    @Override
    protected ExpIcon getIcon() {
        return this.icon;
    }

    private Component buildMessage(ExpText displayName, @Nullable ExpText displayValue) {
        String name = displayName.text().getString();
        if (displayValue == null) {
            return Component.literal((String)name);
        }
        String value = displayValue.text().getString();
        StringBuilder sb = new StringBuilder(value = PATTERN_NEW_LINE.matcher(value).replaceAll("\n"));
        int i = sb.lastIndexOf("\n");
        if (i <= 0) {
            i = 0;
        }
        return Component.literal((String)(name + "\n" + String.valueOf(sb)));
    }
}

