/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.block.CoolerBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.RowedStorageBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CoolerBlockEntity
extends RowedStorageBlockEntity {
    public static final int ROWS = 1;

    public CoolerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.COOLER.get(), pos, state, 1);
    }

    public CoolerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int rows) {
        super(type, pos, state, rows);
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "cooler", new Object[0]);
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.BLOCK_COOLER_OPEN.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setLidState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.BLOCK_COOLER_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setLidState(state, false);
    }

    private void setLidState(BlockState state, boolean open) {
        Level level = this.getLevel();
        if (level != null) {
            level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)CoolerBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }
}

