/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome;

import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.registry.ESDataTransformerTypes;
import cn.leolezury.eternalstarlight.common.world.gen.system.BiomeData;
import cn.leolezury.eternalstarlight.common.world.gen.system.WorldGenProvider;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.DataTransformerType;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.NoiseDataTransformer;
import com.mojang.serialization.MapCodec;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class AddTheAbyssTransformer
extends NoiseDataTransformer {
    public static final MapCodec<AddTheAbyssTransformer> CODEC = RegistryFileCodec.create(ESRegistries.BIOME_DATA, BiomeData.CODEC).fieldOf("the_abyss").xmap(AddTheAbyssTransformer::new, transformer -> transformer.abyss);
    private final Holder<BiomeData> abyss;
    private Integer id = null;

    public AddTheAbyssTransformer(Holder<BiomeData> abyss) {
        this.abyss = abyss;
    }

    @Override
    public int transform(WorldGenProvider provider, Random random, int original, int worldX, int worldZ, PerlinSimplexNoise noise) {
        double noiseVal;
        if (this.id == null) {
            this.id = provider.getBiomeDataId((BiomeData)this.abyss.value());
        }
        if (provider.getBiomeDataById(original).isOcean() && (noiseVal = noise.getValue((double)worldX * 0.0025, (double)worldZ * 0.0025, false) * 0.5 + noise.getValue((double)worldX * 0.0075, (double)worldZ * 0.0075, true) * 0.25 + noise.getValue((double)worldX * 0.025, (double)worldZ * 0.025, true) * 0.025) > -0.04 && noiseVal < 0.04) {
            return this.id;
        }
        return original;
    }

    @Override
    public DataTransformerType<?> type() {
        return ESDataTransformerTypes.ADD_THE_ABYSS.get();
    }
}

