/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree.decorator;

import cn.leolezury.eternalstarlight.common.block.StarfireBirdNestBlock;
import cn.leolezury.eternalstarlight.common.block.entity.StarfireBirdNestBlockEntity;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESTreeDecorators;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class StarfireBirdNestDecorator
extends TreeDecorator {
    public static final MapCodec<StarfireBirdNestDecorator> CODEC = MapCodec.unit(() -> INSTANCE);
    public static final StarfireBirdNestDecorator INSTANCE = new StarfireBirdNestDecorator();

    protected TreeDecoratorType<?> type() {
        return ESTreeDecorators.STARFIRE_BIRD_NEST.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        context.leaves().forEach(pos -> {
            List<Direction> availableDirs;
            BlockPos nestPos;
            boolean nearLog = false;
            for (Direction direction2 : Direction.values()) {
                if (!context.logs().contains((Object)pos.relative(direction2))) continue;
                nearLog = true;
                break;
            }
            if (nearLog && context.isAir(nestPos = pos.relative(Direction.DOWN)) && random.nextInt(100) == 0 && !(availableDirs = Arrays.stream(Direction.values()).filter(direction -> direction.getAxis() != Direction.Axis.Y && context.level().isStateAtPosition(nestPos.relative(direction), BlockBehaviour.BlockStateBase::isAir)).toList()).isEmpty()) {
                context.setBlock(nestPos, (BlockState)((BlockState)ESBlocks.STARFIRE_BIRD_NEST.get().defaultBlockState().setValue((Property)StarfireBirdNestBlock.FACING, (Comparable)availableDirs.get(random.nextInt(availableDirs.size())))).setValue((Property)StarfireBirdNestBlock.EGGS, (Comparable)Integer.valueOf(random.nextInt(2))));
                context.level().getBlockEntity(nestPos, ESBlockEntities.STARFIRE_BIRD_NEST.get()).ifPresent(nest -> {
                    int count = 1 + random.nextInt(2);
                    for (int i = 0; i < count; ++i) {
                        nest.storeBird(StarfireBirdNestBlockEntity.Occupant.create(random, random.nextInt(599)));
                    }
                });
            }
        });
    }
}

