/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.world.gen.feature.ESFeature;
import cn.leolezury.eternalstarlight.common.world.gen.valuemap.RotatedProvider;
import cn.leolezury.eternalstarlight.common.world.gen.valuemap.SpikeProvider;
import cn.leolezury.eternalstarlight.common.world.gen.valuemap.ValueMapGenerator;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class StellagmiteFeature
extends ESFeature<NoneFeatureConfiguration> {
    public StellagmiteFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        ValueMapGenerator.place(new RotatedProvider(new SpikeProvider(1.5f + random.nextFloat(), 10.0f + random.nextFloat() * 3.0f), random.nextInt(-20, 20), random.nextInt(360)), (pos, value) -> {
            BlockState state = ESBlocks.STELLAGMITE.get().defaultBlockState();
            if ((double)value <= 0.8 || (double)random.nextFloat() <= 0.15) {
                state = ESBlocks.MOLTEN_STELLAGMITE.get().defaultBlockState();
            }
            this.setBlockIfEmpty(level, pos.offset((Vec3i)origin), state, true, s -> this.anyMatch((BlockState)s, List.of(ESTags.Blocks.BASE_STONE_STARLIGHT)) || s.canBeReplaced());
        });
        return true;
    }
}

