/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.network;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.util.ESMiscUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record OpenBookPacket(ResourceLocation bookId, Set<ResourceLocation> unlocked) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenBookPacket> TYPE = new CustomPacketPayload.Type(EternalStarlight.id("open_book"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenBookPacket> STREAM_CODEC = StreamCodec.ofMember(OpenBookPacket::write, OpenBookPacket::read);

    public static OpenBookPacket read(FriendlyByteBuf buf) {
        ResourceLocation bookId = ResourceLocation.parse((String)buf.readUtf());
        int size = buf.readInt();
        HashSet<ResourceLocation> unlocked = new HashSet<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            unlocked.add(ResourceLocation.parse((String)buf.readUtf()));
        }
        return new OpenBookPacket(bookId, unlocked);
    }

    public static void write(OpenBookPacket packet, FriendlyByteBuf buf) {
        buf.writeUtf(packet.bookId().toString());
        buf.writeInt(packet.unlocked().size());
        for (ResourceLocation resourceLocation : packet.unlocked()) {
            buf.writeUtf(resourceLocation.toString());
        }
    }

    public static void handle(OpenBookPacket packet, Player player) {
        ESMiscUtil.runWhenOnClient(() -> () -> EternalStarlight.getClientHelper().handleOpenBook(packet));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

