/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.handler.CommonHandlers;
import cn.leolezury.eternalstarlight.common.util.ESWeatherUtil;
import cn.leolezury.eternalstarlight.common.world.gen.biomesource.ESBiomeSource;
import cn.leolezury.eternalstarlight.common.world.gen.chunkgenerator.ESChunkGenerator;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Shadow
    @Final
    List<ServerPlayer> players;

    @ModifyReturnValue(method={"getChunkSource()Lnet/minecraft/server/level/ServerChunkCache;"}, at={@At(value="RETURN")})
    private ServerChunkCache getChunkSource(ServerChunkCache cache) {
        ESChunkGenerator generator;
        ChunkGenerator chunkGenerator;
        if (cache != null && (chunkGenerator = cache.getGenerator()) instanceof ESChunkGenerator && (chunkGenerator = (generator = (ESChunkGenerator)chunkGenerator).getBiomeSource()) instanceof ESBiomeSource) {
            ESBiomeSource source = (ESBiomeSource)chunkGenerator;
            source.setRegistryAccess(((ServerLevel)this).registryAccess());
        }
        return cache;
    }

    @Inject(method={"tickPrecipitation(Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="RETURN")})
    private void tickPrecipitation(BlockPos blockPos, CallbackInfo ci) {
        if (((ServerLevel)this).dimension() == ESDimensions.STARLIGHT_KEY) {
            ESWeatherUtil.getOrCreateWeathers((ServerLevel)this).getActiveWeather().ifPresent(instance -> instance.getWeather().tickBlock((ServerLevel)this, instance.ticksSinceStarted, blockPos));
        }
    }

    @Inject(method={"wakeUpAllPlayers()V"}, at={@At(value="HEAD")})
    private void wakeUpAllPlayers(CallbackInfo ci) {
        this.players.stream().filter(LivingEntity::isSleeping).toList().forEach(serverPlayer -> {
            Optional pos = serverPlayer.getSleepingPos();
            CommonHandlers.onPlayerNaturalWake(serverPlayer, pos.orElse(null));
        });
    }
}

