/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.item.combat.GreatswordItem;
import cn.leolezury.eternalstarlight.common.item.combat.MoonringBowItem;
import cn.leolezury.eternalstarlight.common.util.SpecialItemCooldown;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;

public class MoonringGreatswordItem
extends GreatswordItem {
    public MoonringGreatswordItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.postHurtEnemy(stack, target, attacker);
        Level level = attacker.level();
        if (!level.isClientSide && !SpecialItemCooldown.isOnCooldown((Entity)attacker, (Item)this)) {
            float radiusIncrement = Math.min(target.getBbWidth() * 0.75f, 3.0f);
            for (int i = 0; i < 4; ++i) {
                float radius = (float)(i + 1) * radiusIncrement;
                int num = Math.max(Math.round(7.0f * radius), 5);
                float startAngle = attacker.getRandom().nextFloat() * (float)Math.PI;
                for (int j = 0; j < num; ++j) {
                    float angle = startAngle + (float)Math.PI * 2 / (float)num * (float)j;
                    MoonringBowItem.createThorn(level, attacker, target.getX() + Math.cos(angle) * (double)radius, target.getY(), target.getZ() + Math.sin(angle) * (double)radius, Mth.wrapDegrees((float)(-angle * 57.295776f)), 40.0, i * 7);
                }
            }
            SpecialItemCooldown.setCooldown((Entity)attacker, (Item)this, 125);
        }
    }
}

