/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.misc.ESFallingBlock;
import cn.leolezury.eternalstarlight.common.item.combat.GreatswordItem;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.RingExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.SpecialItemCooldown;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import java.util.ArrayList;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class GolemSteelGreatswordItem
extends GreatswordItem {
    public GolemSteelGreatswordItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.postHurtEnemy(stack, target, attacker);
        Level level = attacker.level();
        if (!level.isClientSide && !SpecialItemCooldown.isOnCooldown((Entity)attacker, (Item)this)) {
            ArrayList hurtEntities = new ArrayList();
            float radius = Math.min(target.getBbWidth() * 4.0f, 12.0f);
            ESBlockUtil.getBlocksInBoundingBox(target.getBoundingBox().inflate((double)radius)).forEach(pos -> {
                BlockState aboveState = level.getBlockState(pos.above());
                if (!level.getBlockState(pos).isAir() && (aboveState.isAir() || aboveState.getBlock() instanceof LiquidBlock) && pos.distToCenterSqr((Position)target.position()) <= (double)radius) {
                    ESFallingBlock fallingBlock = new ESFallingBlock(level, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, level.getBlockState(pos), 40, false);
                    fallingBlock.push(0.0, 0.1 + 0.1 * ((double)radius - Math.sqrt(pos.distToCenterSqr((Position)target.position()))) / (double)radius, 0.0);
                    level.addFreshEntity((Entity)fallingBlock);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles((ParticleOptions)ESExplosionParticleOptions.ENERGY, pos.getCenter().x, pos.getCenter().y, pos.getCenter().z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    for (LivingEntity living : level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(1.0))) {
                        if (!ESEntityUtil.shouldHarm((Entity)attacker, (Entity)living) || hurtEntities.contains(living)) continue;
                        living.invulnerableTime = 0;
                        if (!living.hurt(ESDamageTypes.getDamageSource(level, ESDamageTypes.GROUND_SMASH), 8.0f)) continue;
                        hurtEntities.add(living);
                    }
                }
            });
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!hurtEntities.isEmpty()) {
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(RingExplosionParticleOptions.ENERGY, target.getX(), target.getY(), target.getZ(), 0.0, 0.1, 0.0));
                    ScreenShakeVfx.createInstance((ResourceKey<Level>)level.dimension(), target.position(), 20.0f, 20, 0.1f, 0.2f, 3.0f, 5.5f).send(serverLevel);
                }
            }
            SpecialItemCooldown.setCooldown((Entity)attacker, (Item)this, 80);
        }
    }
}

