/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.monster;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.living.goal.MoveToTargetGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.RandomFlyGoal;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TinyCreteor
extends Monster
implements PowerableMob {
    private static final String TAG_IGNITED = "ignited";
    private static final String TAG_POWERED = "powered";
    private static final String TAG_SWELL = "swell";
    protected static final EntityDataAccessor<Boolean> IGNITED = SynchedEntityData.defineId(TinyCreteor.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> POWERED = SynchedEntityData.defineId(TinyCreteor.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Integer> SWELL = SynchedEntityData.defineId(TinyCreteor.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int oldSwell;
    public float rollAngle;
    public float prevRollAngle;

    public boolean isIgnited() {
        return (Boolean)this.getEntityData().get(IGNITED);
    }

    public void setIgnited(boolean ignited) {
        this.getEntityData().set(IGNITED, (Object)ignited);
    }

    public boolean isPowered() {
        return (Boolean)this.getEntityData().get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.getEntityData().set(POWERED, (Object)powered);
    }

    public int getSwell() {
        return (Integer)this.getEntityData().get(SWELL);
    }

    public void setSwell(int swell) {
        this.getEntityData().set(SWELL, (Object)swell);
    }

    public TinyCreteor(EntityType<? extends TinyCreteor> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setNoGravity(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IGNITED, (Object)false).define(POWERED, (Object)false).define(SWELL, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MoveToTargetGoal((Mob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new RandomFlyGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.tinyCreteor.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.tinyCreteor.armor()).add(Attributes.ATTACK_DAMAGE, ESConfig.INSTANCE.mobsConfig.tinyCreteor.attackDamage()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.tinyCreteor.followRange()).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.FLYING_SPEED, 1.0);
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation(this, (Mob)this, level){

            public boolean isStableDestination(BlockPos blockPos) {
                return this.level.getBlockState(blockPos).isAir();
            }
        };
        navigation.setCanOpenDoors(true);
        navigation.setCanFloat(true);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    public void aiStep() {
        super.aiStep();
        this.oldSwell = this.getSwell();
        if (!this.level().isClientSide) {
            if (this.getSwell() < 80) {
                LivingEntity target = this.getTarget();
                if (this.isIgnited()) {
                    this.setSwell(this.getSwell() + 1);
                } else if (target == null) {
                    this.setSwell(this.getSwell() - 1);
                } else if (this.distanceToSqr((Entity)target) > 25.0) {
                    this.setSwell(this.getSwell() - 1);
                } else if (!this.getSensing().hasLineOfSight((Entity)target)) {
                    this.setSwell(this.getSwell() - 1);
                } else {
                    this.setSwell(this.getSwell() + 1);
                }
                this.setSwell(Mth.clamp((int)this.getSwell(), (int)0, (int)80));
            } else {
                this.explode();
            }
            BlockHitResult result = this.level().clip(new ClipContext(this.position(), this.position().subtract(0.0, 2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (this.onGround() || result.getType() != HitResult.Type.MISS && result.getLocation().distanceTo(this.position()) < 0.5) {
                this.addDeltaMovement(new Vec3(0.0, 0.01, 0.0));
            }
        } else {
            this.prevRollAngle = this.rollAngle;
            this.rollAngle += (float)this.getSwell() / 80.0f * 30.0f;
            if (this.getSwell() == 0) {
                this.rollAngle = Mth.approachDegrees((float)this.rollAngle, (float)0.0f, (float)15.0f);
            }
        }
    }

    public float getSwellProgress(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.oldSwell, (float)this.getSwell()) / 80.0f;
    }

    public void thunderHit(ServerLevel serverLevel, LightningBolt lightningBolt) {
        super.thunderHit(serverLevel, lightningBolt);
        this.setPowered(true);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (itemStack.is(ItemTags.CREEPER_IGNITERS)) {
            SoundEvent soundEvent = itemStack.is(Items.FIRE_CHARGE) ? SoundEvents.FIRECHARGE_USE : SoundEvents.FLINTANDSTEEL_USE;
            this.level().playSound(player, this.getX(), this.getY(), this.getZ(), soundEvent, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            if (!this.level().isClientSide) {
                this.setIgnited(true);
                if (!itemStack.isDamageableItem()) {
                    itemStack.shrink(1);
                } else {
                    itemStack.hurtAndBreak(1, (LivingEntity)player, TinyCreteor.getSlotForHand((InteractionHand)interactionHand));
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, interactionHand);
    }

    private void explode() {
        if (!this.level().isClientSide) {
            this.dead = true;
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), this.isPowered() ? 3.0f : 2.0f, Level.ExplosionInteraction.NONE);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 12; ++i) {
                    Vec3 speed = new Vec3((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)).normalize();
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.AETHERSENT, this.getEyePosition().x + speed.x * 1.2, this.getEyePosition().y + speed.y * 1.2, this.getEyePosition().z + speed.z * 1.2, speed.x, speed.y, speed.z));
                }
            }
            this.playSound(ESSoundEvents.CRETEOR_EXPLODE.get());
            this.spawnLingeringCloud();
            this.triggerOnDeathMobEffects(Entity.RemovalReason.KILLED);
            this.discard();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.getActiveEffects();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            areaEffectCloud.setRadius(2.5f);
            areaEffectCloud.setRadiusOnUse(-0.5f);
            areaEffectCloud.setWaitTime(10);
            areaEffectCloud.setDuration(areaEffectCloud.getDuration() / 2);
            areaEffectCloud.setRadiusPerTick(-areaEffectCloud.getRadius() / (float)areaEffectCloud.getDuration());
            for (MobEffectInstance mobEffectInstance : collection) {
                areaEffectCloud.addEffect(new MobEffectInstance(mobEffectInstance));
            }
            this.level().addFreshEntity((Entity)areaEffectCloud);
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return ESSoundEvents.CRETEOR_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ESSoundEvents.CRETEOR_DEATH.get();
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean(TAG_IGNITED, this.isIgnited());
        compoundTag.putBoolean(TAG_POWERED, this.isPowered());
        compoundTag.putInt(TAG_SWELL, this.getSwell());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setIgnited(compoundTag.getBoolean(TAG_IGNITED));
        this.setPowered(compoundTag.getBoolean(TAG_POWERED));
        this.setSwell(compoundTag.getInt(TAG_SWELL));
    }
}

